/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.editor;

import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.bpmn.project.client.editor.BPMNMigrateDiagramEvent;
import org.kie.workbench.common.stunner.bpmn.project.service.BPMNDiagramEditorService;
import org.kie.workbench.common.stunner.bpmn.project.service.MigrationResult;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.mvp.impl.PathPlaceRequest;

@ApplicationScoped
public class BPMNDiagramEditorHelper {
    static final String BPMN_EXTENSION = ".bpmn";
    static final String BPMN2_EXTENSION = ".bpmn2";
    private final PlaceManager placeManager;
    private final Caller<BPMNDiagramEditorService> editorService;
    private final ClientTranslationService translationService;
    private final ErrorPopupPresenter errorPopupPresenter;

    @Inject
    public BPMNDiagramEditorHelper(PlaceManager placeManager, Caller<BPMNDiagramEditorService> editorService, ClientTranslationService translationService, ErrorPopupPresenter errorPopupPresenter) {
        this.placeManager = placeManager;
        this.editorService = editorService;
        this.translationService = translationService;
        this.errorPopupPresenter = errorPopupPresenter;
    }

    public void onMigrateDiagram(@Observes BPMNMigrateDiagramEvent event) {
        this.placeManager.forceClosePlace(event.getSourcePlace());
        this.migrateDiagram(event.getSourcePath());
    }

    private PlaceManager getPlaceManager() {
        return this.placeManager;
    }

    private void migrateDiagram(Path path) {
        String newExtension;
        String currentExtension;
        String currentName = path.getFileName();
        if (currentName.endsWith(BPMN2_EXTENSION)) {
            currentExtension = BPMN2_EXTENSION;
            newExtension = BPMN_EXTENSION;
        } else {
            currentExtension = BPMN_EXTENSION;
            newExtension = BPMN2_EXTENSION;
        }
        String newName = currentName.substring(0, currentName.length() - currentExtension.length());
        String commitMessage = this.translationService.getValue("editor.actions.migrateCommitMessage", new Object[]{path.getFileName()});
        ((BPMNDiagramEditorService)this.editorService.call(result -> {
            if (result.hasError()) {
                this.errorPopupPresenter.showMessage(this.getErrorMessage((MigrationResult)result));
            } else {
                this.getPlaceManager().goTo(this.createTargetPlace(result.getPath()));
            }
        })).migrateDiagram(path, newName, newExtension, commitMessage);
    }

    private String getErrorMessage(MigrationResult result) {
        if (BPMNDiagramEditorService.ServiceError.MIGRATION_ERROR_PROCESS_ALREADY_EXIST == result.getError()) {
            return this.translationService.getValue("editor.actions.migrateErrorProcessAlreadyExists", new Object[]{result.getPath().getFileName()});
        }
        return this.translationService.getValue("editor.actions.migrateErrorGeneric");
    }

    PlaceRequest createTargetPlace(Path path) {
        return new PathPlaceRequest(path);
    }
}

