/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.service;

import java.util.List;
import java.util.Optional;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.ErrorCallback;
import org.jboss.errai.common.client.api.RemoteCallback;
import org.jboss.errai.security.shared.api.Group;
import org.jboss.errai.security.shared.api.identity.User;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.assigneeEditor.AssigneeLiveSearchService;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.assigneeEditor.AssigneeLocalSearchService;
import org.kie.workbench.common.stunner.bpmn.client.forms.fields.assigneeEditor.widget.AssigneeLiveSearchEntryCreationEditor;
import org.kie.workbench.common.stunner.bpmn.forms.model.AssigneeType;
import org.kie.workbench.common.stunner.core.util.StringUtils;
import org.uberfire.ext.security.management.api.AbstractEntityManager;
import org.uberfire.ext.security.management.client.ClientUserSystemManager;
import org.uberfire.ext.security.management.impl.SearchRequestImpl;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchCallback;
import org.uberfire.ext.widgets.common.client.dropdown.LiveSearchResults;

@Dependent
public class AssigneeLiveSearchProjectService
implements AssigneeLiveSearchService {
    private static final Logger LOGGER = Logger.getLogger(AssigneeLiveSearchProjectService.class.getName());
    private final ClientUserSystemManager userSystemManager;
    private final AssigneeLiveSearchEntryCreationEditor editor;
    private AssigneeLocalSearchService localSearchService;
    private AssigneeType type = AssigneeType.USER;
    private Consumer<Throwable> searchErrorHandler;

    @Inject
    public AssigneeLiveSearchProjectService(ClientUserSystemManager userSystemManager, AssigneeLiveSearchEntryCreationEditor editor) {
        this.userSystemManager = userSystemManager;
        this.editor = editor;
    }

    @PostConstruct
    public void postConstruct() {
        this.localSearchService = AssigneeLocalSearchService.build((AssigneeLiveSearchEntryCreationEditor)this.editor);
    }

    public void init(AssigneeType type) {
        this.type = type;
    }

    public void setSearchErrorHandler(Consumer<Throwable> searchErrorHandler) {
        this.searchErrorHandler = searchErrorHandler;
    }

    public void search(String pattern, int maxResults, LiveSearchCallback<String> callback) {
        List filteredCustomEntries = this.localSearchService.search(pattern);
        RemoteCallback searchResponseRemoteCallback = response -> this.processFilterResponse((AbstractEntityManager.SearchResponse<?>)response, filteredCustomEntries, maxResults, callback);
        ErrorCallback searchErrorCallback = (message, throwable) -> this.processSearchError(filteredCustomEntries, maxResults, callback, throwable);
        SearchRequestImpl request = new SearchRequestImpl(pattern, 1, maxResults);
        if (AssigneeType.USER.equals((Object)this.type)) {
            this.userSystemManager.users(searchResponseRemoteCallback, searchErrorCallback).search((AbstractEntityManager.SearchRequest)request);
        } else {
            this.userSystemManager.groups(searchResponseRemoteCallback, searchErrorCallback).search((AbstractEntityManager.SearchRequest)request);
        }
    }

    public void addCustomEntry(String customEntry) {
        this.localSearchService.addCustomEntry(customEntry);
    }

    public AssigneeLiveSearchEntryCreationEditor getEditor() {
        return this.editor;
    }

    public void searchEntry(String key, LiveSearchCallback<String> callback) {
        SearchRequestImpl request = new SearchRequestImpl(key, 1, 1);
        ErrorCallback searchErrorCallback = (message, throwable) -> this.processSearchEntryError(key, callback, throwable);
        RemoteCallback searchResponseRemoteCallback = response -> this.searchEntry(key, (AbstractEntityManager.SearchResponse<?>)response, callback);
        if (AssigneeType.USER.equals((Object)this.type)) {
            this.userSystemManager.users(searchResponseRemoteCallback, searchErrorCallback).search((AbstractEntityManager.SearchRequest)request);
        } else {
            this.userSystemManager.groups(searchResponseRemoteCallback, searchErrorCallback).search((AbstractEntityManager.SearchRequest)request);
        }
    }

    @PreDestroy
    public void destroy() {
        this.localSearchService.destroy();
        this.localSearchService = null;
    }

    private boolean processSearchEntryError(String key, LiveSearchCallback<String> callback, Throwable throwable) {
        LiveSearchResults results = new LiveSearchResults(1);
        if (!StringUtils.isEmpty((String)key)) {
            this.addCustomEntry(key);
            results.add(key, key);
        }
        callback.afterSearch(results);
        this.processError("It was not possible to get user or group: " + key + " from the users system.", throwable);
        return false;
    }

    private boolean processSearchError(List<String> filteredCustomEntries, int maxResults, LiveSearchCallback<String> callback, Throwable throwable) {
        int maxSize = maxResults > filteredCustomEntries.size() ? filteredCustomEntries.size() : maxResults;
        maxSize = maxSize < 0 ? 0 : maxSize;
        LiveSearchResults result = new LiveSearchResults(maxSize);
        filteredCustomEntries.subList(0, maxSize).forEach(entry -> result.add(entry, entry));
        callback.afterSearch(result);
        this.processError("It was not possible to execute search on the users system.", throwable);
        return false;
    }

    private void processError(String errorMessage, Throwable throwable) {
        LOGGER.log(Level.SEVERE, errorMessage, throwable);
        if (this.searchErrorHandler != null) {
            this.searchErrorHandler.accept(throwable);
        }
    }

    private void searchEntry(String key, AbstractEntityManager.SearchResponse<?> response, LiveSearchCallback<String> liveSearchCallback) {
        LiveSearchResults results = new LiveSearchResults(1);
        if (key != null) {
            Optional<Object> exists;
            if (!this.getCustomEntries().contains(key) && !(exists = response.getResults().stream().filter(item -> {
                String value = null;
                if (item instanceof User) {
                    value = ((User)item).getIdentifier();
                } else if (item instanceof Group) {
                    value = ((Group)item).getName();
                }
                return key.equals(value);
            }).findAny()).isPresent()) {
                this.addCustomEntry(key);
            }
            results.add(key, key);
        }
        liveSearchCallback.afterSearch(results);
    }

    protected void processFilterResponse(AbstractEntityManager.SearchResponse<?> response, List<String> filteredCustomEntries, int maxResults, LiveSearchCallback<String> liveSearchCallback) {
        TreeSet<String> values = new TreeSet<String>(filteredCustomEntries);
        response.getResults().forEach(item -> {
            String value = null;
            if (item instanceof User) {
                value = ((User)item).getIdentifier();
            } else if (item instanceof Group) {
                value = ((Group)item).getName();
            }
            if (value != null) {
                values.add(value);
            }
        });
        if (maxResults > values.size()) {
            maxResults = values.size();
        }
        LiveSearchResults results = AssigneeLocalSearchService.createSearchResults(values, (int)maxResults);
        liveSearchCallback.afterSearch(results);
    }

    List<String> getCustomEntries() {
        return this.localSearchService.getCustomEntries();
    }
}

