/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.workitem;

import elemental2.promise.Promise;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.PreDestroy;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.Default;
import javax.enterprise.inject.Produces;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.bpmn.client.workitem.WorkItemDefinitionClientService;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinition;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionCacheRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistries;
import org.kie.workbench.common.stunner.bpmn.workitem.WorkItemDefinitionRegistry;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.session.ClientSession;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.uberfire.client.promise.Promises;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;

@ApplicationScoped
public class WorkItemDefinitionProjectClientService
implements WorkItemDefinitionClientService {
    private final Promises promises;
    private final Caller<WorkItemDefinitionLookupService> service;
    private final WorkItemDefinitionRegistries<Metadata> index;
    private final SessionManager sessionManager;
    private final Supplier<WorkItemDefinitionCacheRegistry> registryInstanceSupplier;
    private final Consumer<Throwable> errorPresenter;

    @Inject
    public WorkItemDefinitionProjectClientService(Promises promises, Caller<WorkItemDefinitionLookupService> service, SessionManager sessionManager, ManagedInstance<WorkItemDefinitionCacheRegistry> registryInstances, ErrorPopupPresenter errorPopupPresenter) {
        this(promises, service, sessionManager, () -> registryInstances.get(), exception -> errorPopupPresenter.showMessage(WorkItemDefinitionProjectClientService.getExceptionMessage(exception)), (WorkItemDefinitionRegistries<Metadata>)new WorkItemDefinitionRegistries(metadata -> metadata.getRoot().toURI(), new HashMap(), arg_0 -> registryInstances.destroy(arg_0)));
    }

    WorkItemDefinitionProjectClientService(Promises promises, Caller<WorkItemDefinitionLookupService> service, SessionManager sessionManager, Supplier<WorkItemDefinitionCacheRegistry> registryInstances, Consumer<Throwable> errorPresenter, WorkItemDefinitionRegistries<Metadata> index) {
        this.promises = promises;
        this.service = service;
        this.sessionManager = sessionManager;
        this.registryInstanceSupplier = registryInstances;
        this.errorPresenter = errorPresenter;
        this.index = index;
    }

    @Produces
    @Default
    public WorkItemDefinitionRegistry getRegistry() {
        return this.getCurrentSessionRegistry();
    }

    public Promise<Collection<WorkItemDefinition>> call(Metadata metadata) {
        return this.promises.promisify(this.service, s -> s.execute((Object)metadata)).then(workItemDefinitions -> {
            WorkItemDefinitionCacheRegistry registry = this.getRegistryForModule(metadata);
            workItemDefinitions.forEach(arg_0 -> ((WorkItemDefinitionCacheRegistry)registry).register(arg_0));
            return this.promises.resolve(workItemDefinitions);
        }).catch_(error -> {
            this.errorPresenter.accept((Throwable)error);
            return this.promises.resolve(Collections.emptyList());
        });
    }

    public void removeRegistry(Metadata metadata) {
        Optional.ofNullable(this.index.remove((Object)metadata)).ifPresent(WorkItemDefinitionCacheRegistry::clear);
    }

    @PreDestroy
    public void destroy() {
        this.index.clear();
    }

    void onSessionDestroyed(@Observes SessionDestroyedEvent sessionDestroyedEvent) {
        this.removeRegistry(sessionDestroyedEvent.getMetadata());
    }

    WorkItemDefinitionCacheRegistry getCurrentSessionRegistry() {
        return this.getRegistryForSession(this.sessionManager.getCurrentSession());
    }

    WorkItemDefinitionCacheRegistry getRegistryForSession(ClientSession session) {
        return this.getRegistryForModule(session.getCanvasHandler().getDiagram().getMetadata());
    }

    WorkItemDefinitionCacheRegistry getRegistryForModule(Metadata metadata) {
        return this.obtainRegistry(metadata);
    }

    private WorkItemDefinitionCacheRegistry obtainRegistry(Metadata metadata) {
        if (!this.index.contains((Object)metadata)) {
            this.index.put((Object)metadata, this.registryInstanceSupplier.get());
        }
        return (WorkItemDefinitionCacheRegistry)this.index.registries().apply(metadata);
    }

    private static String getExceptionMessage(Throwable throwable) {
        Throwable root;
        for (root = throwable; null != root && null != root.getCause(); root = root.getCause()) {
        }
        String msg = null != root.getMessage() ? root.getMessage() : root.toString();
        return "Cannot load Work Item definitions. Cause: " + msg;
    }
}

