/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import java.util.Collection;
import java.util.function.Consumer;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.bpmn.project.client.editor.BPMNProjectEditorMenuSessionItems;
import org.kie.workbench.common.stunner.bpmn.project.client.type.BPMNDiagramResourceType;
import org.kie.workbench.common.stunner.bpmn.qualifiers.BPMN;
import org.kie.workbench.common.stunner.client.widgets.editor.StunnerEditor;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.event.screen.ScreenMaximizedEvent;
import org.kie.workbench.common.stunner.core.client.event.screen.ScreenMinimizedEvent;
import org.kie.workbench.common.stunner.core.client.event.screen.ScreenPreMaximizedStateEvent;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.documentation.DocumentationView;
import org.kie.workbench.common.stunner.project.client.docks.StunnerDocksHandler;
import org.kie.workbench.common.stunner.project.client.editor.AbstractDiagramEditorMenuSessionItems;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.service.ProjectDiagramResourceService;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.workbench.docks.UberfireDock;
import org.uberfire.client.workbench.docks.UberfireDocks;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchEditor(identifier="BPMNDiagramEditor", supportedTypes={BPMNDiagramResourceType.class})
public class BPMNDiagramEditor
extends AbstractProjectDiagramEditor<BPMNDiagramResourceType> {
    public static final String EDITOR_ID = "BPMNDiagramEditor";
    private final UberfireDocks uberfireDocks;
    private final StunnerDocksHandler stunnerDocksHandler;
    private boolean isMigrating = false;
    private boolean isPropertiesOpenedBeforeMaximize = false;
    private boolean isExplorerOpenedBeforeMaximize = false;

    @Inject
    public BPMNDiagramEditor(AbstractProjectDiagramEditor.View view, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, @BPMN DocumentationView documentationView, BPMNDiagramResourceType resourceType, BPMNProjectEditorMenuSessionItems menuSessionItems, ProjectMessagesListener projectMessagesListener, ClientTranslationService translationService, ClientProjectDiagramService projectDiagramServices, Caller<ProjectDiagramResourceService> projectDiagramResourceServiceCaller, StunnerEditor stunnerEditor, UberfireDocks uberfireDocks, StunnerDocksHandler stunnerDocksHandler) {
        super(view, onDiagramFocusEvent, onDiagramLostFocusEvent, documentationView, (ClientResourceType)resourceType, (AbstractDiagramEditorMenuSessionItems)menuSessionItems, projectMessagesListener, translationService, projectDiagramServices, projectDiagramResourceServiceCaller, stunnerEditor);
        this.uberfireDocks = uberfireDocks;
        this.stunnerDocksHandler = stunnerDocksHandler;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.doStartUp(path, place);
    }

    public String getEditorIdentifier() {
        return EDITOR_ID;
    }

    protected void beforeOpen(ProjectDiagram diagram) {
        super.beforeOpen(diagram);
        this.getStunnerEditor().close();
    }

    @OnOpen
    public void onOpen() {
        this.openPropertiesDocks();
    }

    private void performDockOperation(String id, Consumer<? super UberfireDock> action) {
        String currentPerspectiveIdentifier = this.perspectiveManager.getCurrentPerspective().getIdentifier();
        Collection stunnerDocks = this.stunnerDocksHandler.provideDocks(currentPerspectiveIdentifier);
        stunnerDocks.stream().filter(dock -> dock.getPlaceRequest().getIdentifier().compareTo(id) == 0).forEach(action);
    }

    public void openPropertiesDocks() {
        this.performDockOperation("DiagramEditorPropertiesScreen", arg_0 -> ((UberfireDocks)this.uberfireDocks).open(arg_0));
    }

    public void openExplorerDocks() {
        this.performDockOperation("ProjectDiagramExplorerScreen", arg_0 -> ((UberfireDocks)this.uberfireDocks).open(arg_0));
    }

    public void onScreenMaximizedEvent(@Observes ScreenMaximizedEvent event) {
        this.isPropertiesOpenedBeforeMaximize = false;
        this.isExplorerOpenedBeforeMaximize = false;
    }

    public void onScreenPreMaximizedStateEvent(@Observes ScreenPreMaximizedStateEvent event) {
        this.isPropertiesOpenedBeforeMaximize = !event.isExplorerScreen();
        this.isExplorerOpenedBeforeMaximize = event.isExplorerScreen();
    }

    public void onScreenMinimizedEvent(@Observes ScreenMinimizedEvent event) {
        if (this.isPropertiesOpenedBeforeMaximize) {
            this.openPropertiesDocks();
        } else if (this.isExplorerOpenedBeforeMaximize) {
            this.openExplorerDocks();
        }
    }

    @OnClose
    public void onClose() {
        super.doClose();
    }

    @OnFocus
    public void onFocus() {
        this.getStunnerEditor().focus();
    }

    @OnLostFocus
    public void onLostFocus() {
        this.getStunnerEditor().lostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public void getMenus(Consumer<Menus> menusConsumer) {
        super.getMenus(menusConsumer);
    }

    @WorkbenchPartView
    public IsWidget getWidget() {
        return super.getWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(this.getCurrentContentHash());
    }

    protected void onSaveSuccess() {
        super.onSaveSuccess();
        if (this.isMigrating) {
            this.isMigrating = false;
        }
    }

    public void onError(ClientRuntimeError error) {
        super.onError(error);
        if (this.isMigrating) {
            this.isMigrating = false;
        }
    }
}

