/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.canvas.controls;

import java.util.Collection;
import java.util.LinkedList;
import javax.annotation.PreDestroy;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Any;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.bpmn.client.forms.util.BPMNFormsContextUtils;
import org.kie.workbench.common.stunner.bpmn.client.util.GraphUtils;
import org.kie.workbench.common.stunner.bpmn.project.client.toolbox.OpenSubprocessToolboxAction;
import org.kie.workbench.common.stunner.bpmn.qualifiers.BPMN;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.AbstractActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ActionsToolboxView;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.CommonActionsToolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.forms.client.components.toolbox.FormGenerationToolboxAction;

@Dependent
@BPMN
public class BPMNProjectActionsToolboxFactory
extends AbstractActionsToolboxFactory {
    private final ActionsToolboxFactory commonActionToolbox;
    private final ManagedInstance<FormGenerationToolboxAction> generateFormsActions;
    private final ManagedInstance<OpenSubprocessToolboxAction> openSubprocessActions;
    private final ManagedInstance<ActionsToolboxView> views;

    @Inject
    public BPMNProjectActionsToolboxFactory(@CommonActionsToolbox ActionsToolboxFactory commonActionToolbox, @Any ManagedInstance<FormGenerationToolboxAction> generateFormsActions, @Any ManagedInstance<OpenSubprocessToolboxAction> openSubprocessActions, @Any @CommonActionsToolbox ManagedInstance<ActionsToolboxView> views) {
        this.commonActionToolbox = commonActionToolbox;
        this.generateFormsActions = generateFormsActions;
        this.openSubprocessActions = openSubprocessActions;
        this.views = views;
    }

    protected ActionsToolboxView<?> newViewInstance() {
        return (ActionsToolboxView)this.views.get();
    }

    public Collection<ToolboxAction<AbstractCanvasHandler>> getActions(AbstractCanvasHandler canvasHandler, Element<?> e) {
        LinkedList<ToolboxAction<AbstractCanvasHandler>> actions = new LinkedList<ToolboxAction<AbstractCanvasHandler>>();
        actions.addAll(this.commonActionToolbox.getActions(canvasHandler, e));
        if (BPMNFormsContextUtils.isFormGenerationSupported(e)) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)this.generateFormsActions.get());
        }
        if (GraphUtils.isReusableSubProcess(e)) {
            actions.add((ToolboxAction<AbstractCanvasHandler>)this.openSubprocessActions.get());
        }
        return actions;
    }

    @PreDestroy
    public void destroy() {
        this.generateFormsActions.destroyAll();
        this.openSubprocessActions.destroyAll();
        this.views.destroyAll();
    }
}

