/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.diagram;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.bpmn.client.diagram.DiagramTypeClientService;
import org.kie.workbench.common.stunner.bpmn.project.service.BPMNDiagramService;
import org.kie.workbench.common.stunner.bpmn.service.ProjectType;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDestroyedEvent;
import org.kie.workbench.common.stunner.core.diagram.Metadata;

@ApplicationScoped
public class DiagramTypeClientProjectService
implements DiagramTypeClientService {
    private final Caller<BPMNDiagramService> bpmnDiagramService;
    private static final Map<String, ProjectType> projectTypeRegistry = new HashMap<String, ProjectType>();

    DiagramTypeClientProjectService() {
        this(null);
    }

    @Inject
    public DiagramTypeClientProjectService(Caller<BPMNDiagramService> bpmnDiagramService) {
        this.bpmnDiagramService = bpmnDiagramService;
    }

    public void loadDiagramType(Metadata metadata) {
        ((BPMNDiagramService)this.bpmnDiagramService.call(r -> this.setProjectType(metadata, (ProjectType)r))).getProjectType(metadata.getRoot());
    }

    void setProjectType(Metadata metadata, ProjectType projectType) {
        projectTypeRegistry.put(this.getDiagramId(metadata), projectType);
    }

    private String getDiagramId(Metadata metadata) {
        return metadata.getCanvasRootUUID();
    }

    public ProjectType getProjectType(Metadata metadata) {
        return Optional.ofNullable(projectTypeRegistry.get(this.getDiagramId(metadata))).orElse(ProjectType.BPMN);
    }

    protected void onSessionClosed(@Observes SessionDestroyedEvent event) {
        projectTypeRegistry.remove(this.getDiagramId(event.getMetadata()));
    }
}

