/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.editor;

import java.util.logging.Logger;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.bpmn.project.client.type.BPMNDiagramResourceType;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasFileExport;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientDiagramService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.session.event.SessionDiagramHandler;
import org.kie.workbench.common.stunner.core.client.session.impl.EditorSession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.uberfire.backend.vfs.Path;
import org.uberfire.workbench.events.NotificationEvent;

public abstract class BPMNProjectBaseSessionDiagramHandler
implements SessionDiagramHandler {
    private static Logger LOGGER = Logger.getLogger(BPMNProjectBaseSessionDiagramHandler.class.getName());
    private final BPMNDiagramResourceType bpmnDiagramResourceType;
    private final ClientDiagramService diagramService;
    private final CanvasFileExport canvasExport;
    private final Event<NotificationEvent> notificationEvent;
    private final ClientTranslationService translationService;

    public BPMNProjectBaseSessionDiagramHandler(BPMNDiagramResourceType bpmnDiagramResourceType, ClientDiagramService diagramService, CanvasFileExport canvasExport, Event<NotificationEvent> notificationEvent, ClientTranslationService translationService) {
        this.bpmnDiagramResourceType = bpmnDiagramResourceType;
        this.diagramService = diagramService;
        this.canvasExport = canvasExport;
        this.notificationEvent = notificationEvent;
        this.translationService = translationService;
    }

    public boolean accepts(Diagram diagram) {
        return diagram instanceof ProjectDiagram && this.bpmnDiagramResourceType.accept(diagram.getMetadata().getPath());
    }

    protected void saveOrUpdateDiagram(EditorSession session) {
        AbstractCanvasHandler canvasHandler = (AbstractCanvasHandler)session.getCanvasHandler();
        session.getSelectionControl().clearSelection();
        String rawSvg = this.canvasExport.exportToSvg(canvasHandler);
        final Path path = canvasHandler.getDiagram().getMetadata().getPath();
        this.diagramService.saveOrUpdateSvg(path, rawSvg, (ServiceCallback)new ServiceCallback<Path>(){

            public void onSuccess(Path path2) {
                LOGGER.info("Diagram SVG saved on " + path2);
            }

            public void onError(ClientRuntimeError error) {
                BPMNProjectBaseSessionDiagramHandler.this.notificationEvent.fire((Object)new NotificationEvent(BPMNProjectBaseSessionDiagramHandler.this.translationService.getValue("editor.error.generateSvgFileError"), NotificationEvent.NotificationType.ERROR));
                LOGGER.severe("An error was produced when generating svg for diagram: " + path + ":" + error.getMessage());
            }
        });
    }
}

