/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.service;

import elemental2.promise.Promise;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.common.client.api.Caller;
import org.kie.workbench.common.stunner.bpmn.client.forms.DataTypeNamesService;
import org.kie.workbench.common.stunner.bpmn.project.service.DataTypesService;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.promise.Promises;

@ApplicationScoped
public class DataTypeNamesProjectService
implements DataTypeNamesService {
    private final Promises promises;
    private final Caller<DataTypesService> dataTypesServiceCaller;
    private static Set<String> simpleDataTypes = new HashSet<String>(Arrays.asList("Boolean", "Float", "Integer", "Object", "String"));
    protected List<String> addedDataTypes = new ArrayList<String>();

    @Inject
    public DataTypeNamesProjectService(Promises promises, Caller<DataTypesService> dataTypesServiceCaller) {
        this.promises = promises;
        this.dataTypesServiceCaller = dataTypesServiceCaller;
    }

    public Promise<List<String>> call(Path path) {
        return this.promises.promisify(this.dataTypesServiceCaller, dataTypesService -> {
            this.extractDefaultDataTypes();
            dataTypesService.getDataTypeNames(path, this.addedDataTypes);
        });
    }

    protected void extractDefaultDataTypes() {
        this.addedDataTypes.removeAll(simpleDataTypes);
    }

    public void add(String value, String oldValue) {
        if (simpleDataTypes.contains(value)) {
            return;
        }
        if (this.addedDataTypes.contains(oldValue)) {
            this.addedDataTypes.remove(oldValue);
        }
        this.addedDataTypes.add(value);
    }

    public void reset() {
        this.addedDataTypes.clear();
    }
}

