/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.toolbox;

import com.google.gwt.safehtml.shared.SafeHtmlBuilder;
import java.util.List;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.gwtbootstrap3.client.ui.constants.IconType;
import org.gwtbootstrap3.extras.notify.client.ui.Notify;
import org.kie.workbench.common.stunner.bpmn.client.forms.util.StringUtils;
import org.kie.workbench.common.stunner.bpmn.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.project.client.service.ClientProjectOpenReusableSubprocessService;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.components.toolbox.actions.ToolboxAction;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.resources.StunnerCommonIconsGlyphFactory;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.definition.shape.Glyph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;

@Dependent
public class OpenSubprocessToolboxAction
implements ToolboxAction<AbstractCanvasHandler> {
    private final ClientTranslationService translationService;
    private final ClientProjectOpenReusableSubprocessService openSubprocessService;

    @Inject
    public OpenSubprocessToolboxAction(ClientTranslationService translationService, ClientProjectOpenReusableSubprocessService openSubprocessService) {
        this.translationService = translationService;
        this.openSubprocessService = openSubprocessService;
    }

    public Glyph getGlyph(AbstractCanvasHandler canvasHandler, String uuid) {
        return StunnerCommonIconsGlyphFactory.SUBPROCESS;
    }

    public String getTitle(AbstractCanvasHandler canvasHandler, String uuid) {
        return this.translationService.getValue("editor.toolbox.openSubprocessToolboxAction");
    }

    public ToolboxAction<AbstractCanvasHandler> onMouseClick(AbstractCanvasHandler canvasHandler, String uuid, MouseClickEvent event) {
        String processId = this.getProcessId(canvasHandler, uuid);
        if (StringUtils.isEmpty((String)processId)) {
            this.showNotification(this.translationService.getValue("editor.error.subprocessNotSpecified"));
            return this;
        }
        this.openSubprocessService.call(processId).then(serverData -> {
            this.openSubprocess((List<String>)serverData, processId);
            return null;
        }).catch_(exception -> {
            this.showNotification(this.translationService.getValue("editor.error.subprocessNotFound", new Object[]{processId}));
            return null;
        });
        return this;
    }

    public String getProcessId(AbstractCanvasHandler canvasHandler, String uuid) {
        Node node = canvasHandler.getDiagram().getGraph().getNode(uuid);
        ReusableSubprocess subprocess = (ReusableSubprocess)((View)node.getContent()).getDefinition();
        return subprocess.getExecutionSet().getCalledElement().getValue();
    }

    public void openSubprocess(List<String> serverData, String processId) {
        if (serverData.size() == 2) {
            this.openSubprocessService.openReusableSubprocess(serverData);
        } else {
            this.showNotification(this.translationService.getValue("editor.error.subprocessNotFound", new Object[]{processId}));
        }
    }

    public void showNotification(String message) {
        Notify.notify((String)"", (String)OpenSubprocessToolboxAction.buildHtmlEscapedText(message), (IconType)IconType.EXCLAMATION);
    }

    private static String buildHtmlEscapedText(String message) {
        return new SafeHtmlBuilder().appendEscapedLines(message).toSafeHtml().asString();
    }
}

