/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.client.editor;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.api.ManagedInstance;
import org.kie.workbench.common.stunner.bpmn.client.forms.util.ContextUtils;
import org.kie.workbench.common.stunner.bpmn.project.client.editor.BPMNDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.bpmn.project.client.editor.BPMNMigrateDiagramEvent;
import org.kie.workbench.common.stunner.bpmn.project.client.type.BPMNDiagramResourceType;
import org.kie.workbench.common.stunner.client.widgets.popups.PopupUtil;
import org.kie.workbench.common.stunner.client.widgets.presenters.session.SessionPresenterFactory;
import org.kie.workbench.common.stunner.core.client.annotation.DiagramEditor;
import org.kie.workbench.common.stunner.core.client.api.SessionManager;
import org.kie.workbench.common.stunner.core.client.error.DiagramClientErrorHandler;
import org.kie.workbench.common.stunner.core.client.i18n.ClientTranslationService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.session.command.AbstractClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.ClientSessionCommand;
import org.kie.workbench.common.stunner.core.client.session.command.impl.SessionCommandFactory;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientFullSession;
import org.kie.workbench.common.stunner.core.client.session.impl.AbstractClientReadOnlySession;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.forms.client.session.command.GenerateDiagramFormsSessionCommand;
import org.kie.workbench.common.stunner.forms.client.session.command.GenerateProcessFormsSessionCommand;
import org.kie.workbench.common.stunner.forms.client.session.command.GenerateSelectedFormsSessionCommand;
import org.kie.workbench.common.stunner.project.client.editor.AbstractProjectDiagramEditor;
import org.kie.workbench.common.stunner.project.client.editor.ProjectDiagramEditorMenuItemsBuilder;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramFocusEvent;
import org.kie.workbench.common.stunner.project.client.editor.event.OnDiagramLoseFocusEvent;
import org.kie.workbench.common.stunner.project.client.screens.ProjectMessagesListener;
import org.kie.workbench.common.stunner.project.client.service.ClientProjectDiagramService;
import org.kie.workbench.common.widgets.client.menu.FileMenuBuilder;
import org.uberfire.backend.vfs.ObservablePath;
import org.uberfire.backend.vfs.Path;
import org.uberfire.client.annotations.WorkbenchEditor;
import org.uberfire.client.annotations.WorkbenchMenu;
import org.uberfire.client.annotations.WorkbenchPartTitle;
import org.uberfire.client.annotations.WorkbenchPartTitleDecoration;
import org.uberfire.client.annotations.WorkbenchPartView;
import org.uberfire.client.mvp.PlaceManager;
import org.uberfire.client.views.pfly.widgets.Button;
import org.uberfire.client.views.pfly.widgets.InlineNotification;
import org.uberfire.client.workbench.events.ChangeTitleWidgetEvent;
import org.uberfire.client.workbench.type.ClientResourceType;
import org.uberfire.client.workbench.widgets.common.ErrorPopupPresenter;
import org.uberfire.ext.editor.commons.client.file.popups.SavePopUpPresenter;
import org.uberfire.lifecycle.OnClose;
import org.uberfire.lifecycle.OnFocus;
import org.uberfire.lifecycle.OnLostFocus;
import org.uberfire.lifecycle.OnMayClose;
import org.uberfire.lifecycle.OnOpen;
import org.uberfire.lifecycle.OnStartup;
import org.uberfire.mvp.Command;
import org.uberfire.mvp.PlaceRequest;
import org.uberfire.workbench.model.menu.Menus;

@Dependent
@DiagramEditor
@WorkbenchEditor(identifier="BPMNDiagramEditor", supportedTypes={BPMNDiagramResourceType.class})
public class BPMNDiagramEditor
extends AbstractProjectDiagramEditor<BPMNDiagramResourceType> {
    public static final String EDITOR_ID = "BPMNDiagramEditor";
    private final ManagedInstance<GenerateProcessFormsSessionCommand> generateProcessFormSessionCommands;
    private final ManagedInstance<GenerateDiagramFormsSessionCommand> generateDiagramFormsSessionCommands;
    private final ManagedInstance<GenerateSelectedFormsSessionCommand> generateSelectedFormsSessionCommands;
    private final BPMNDiagramEditorMenuItemsBuilder bpmnDiagramEditorMenuItemsBuilder;
    private final Event<BPMNMigrateDiagramEvent> migrateDiagramEvent;
    private boolean isMigrating = false;
    private final PopupUtil popupUtil;

    @Inject
    public BPMNDiagramEditor(AbstractProjectDiagramEditor.View view, PlaceManager placeManager, ErrorPopupPresenter errorPopupPresenter, Event<ChangeTitleWidgetEvent> changeTitleNotificationEvent, SavePopUpPresenter savePopUpPresenter, BPMNDiagramResourceType resourceType, ClientProjectDiagramService projectDiagramServices, SessionManager sessionManager, SessionPresenterFactory<Diagram, AbstractClientReadOnlySession, AbstractClientFullSession> sessionPresenterFactory, SessionCommandFactory sessionCommandFactory, ProjectDiagramEditorMenuItemsBuilder menuItemsBuilder, Event<OnDiagramFocusEvent> onDiagramFocusEvent, Event<OnDiagramLoseFocusEvent> onDiagramLostFocusEvent, ProjectMessagesListener projectMessagesListener, DiagramClientErrorHandler diagramClientErrorHandler, ManagedInstance<GenerateProcessFormsSessionCommand> generateProcessFormSessionCommands, ManagedInstance<GenerateDiagramFormsSessionCommand> generateDiagramFormsSessionCommands, ManagedInstance<GenerateSelectedFormsSessionCommand> generateSelectedFormsSessionCommands, BPMNDiagramEditorMenuItemsBuilder bpmnDiagramEditorMenuItemsBuilder, ClientTranslationService translationService, Event<BPMNMigrateDiagramEvent> migrateDiagramEvent, PopupUtil popupUtil) {
        super(view, placeManager, errorPopupPresenter, changeTitleNotificationEvent, savePopUpPresenter, (ClientResourceType)resourceType, projectDiagramServices, sessionManager, sessionPresenterFactory, sessionCommandFactory, menuItemsBuilder, onDiagramFocusEvent, onDiagramLostFocusEvent, projectMessagesListener, diagramClientErrorHandler, translationService);
        this.generateProcessFormSessionCommands = generateProcessFormSessionCommands;
        this.generateDiagramFormsSessionCommands = generateDiagramFormsSessionCommands;
        this.generateSelectedFormsSessionCommands = generateSelectedFormsSessionCommands;
        this.bpmnDiagramEditorMenuItemsBuilder = bpmnDiagramEditorMenuItemsBuilder;
        this.migrateDiagramEvent = migrateDiagramEvent;
        this.popupUtil = popupUtil;
    }

    @OnStartup
    public void onStartup(ObservablePath path, PlaceRequest place) {
        super.doStartUp(path, place);
    }

    protected void initializeCommands(Map<Class, ClientSessionCommand> commands) {
        super.initializeCommands(commands);
        commands.put(GenerateProcessFormsSessionCommand.class, (ClientSessionCommand)this.generateProcessFormSessionCommands.get());
        commands.put(GenerateDiagramFormsSessionCommand.class, (ClientSessionCommand)this.generateDiagramFormsSessionCommands.get());
        commands.put(GenerateSelectedFormsSessionCommand.class, (ClientSessionCommand)((GenerateSelectedFormsSessionCommand)this.generateSelectedFormsSessionCommands.get()).setElementAcceptor(ContextUtils::isFormGenerationSupported));
    }

    protected void makeAdditionalStunnerMenus(FileMenuBuilder fileMenuBuilder) {
        super.makeAdditionalStunnerMenus(fileMenuBuilder);
        fileMenuBuilder.addNewTopLevelMenu(this.bpmnDiagramEditorMenuItemsBuilder.newFormsGenerationMenuItem(() -> this.executeFormsCommand(GenerateProcessFormsSessionCommand.class), () -> this.executeFormsCommand(GenerateDiagramFormsSessionCommand.class), () -> this.executeFormsCommand(GenerateSelectedFormsSessionCommand.class))).addNewTopLevelMenu(this.bpmnDiagramEditorMenuItemsBuilder.newMigrateMenuItem(this::onMigrate));
    }

    protected int getCanvasWidth() {
        return 2800;
    }

    protected int getCanvasHeight() {
        return 1400;
    }

    protected String getEditorIdentifier() {
        return EDITOR_ID;
    }

    @OnOpen
    public void onOpen() {
        super.doOpen();
    }

    @OnClose
    public void onClose() {
        super.doClose();
    }

    @OnFocus
    public void onFocus() {
        super.doFocus();
    }

    @OnLostFocus
    public void onLostFocus() {
        super.doLostFocus();
    }

    @WorkbenchPartTitleDecoration
    public IsWidget getTitle() {
        return super.getTitle();
    }

    @WorkbenchPartTitle
    public String getTitleText() {
        return super.getTitleText();
    }

    @WorkbenchMenu
    public Menus getMenus() {
        return super.getMenus();
    }

    @WorkbenchPartView
    public Widget getWidget() {
        return this.getView().asWidget();
    }

    @OnMayClose
    public boolean onMayClose() {
        return super.mayClose(Integer.valueOf(this.getCurrentDiagramHash()));
    }

    private void executeFormsCommand(Class<? extends AbstractClientSessionCommand> type) {
        this.showLoadingViews();
        ((AbstractClientSessionCommand)this.getCommand(type)).execute((ClientSessionCommand.Callback)new ClientSessionCommand.Callback<ClientRuntimeError>(){

            public void onSuccess() {
                BPMNDiagramEditor.this.hideLoadingViews();
            }

            public void onError(ClientRuntimeError error) {
                BPMNDiagramEditor.this.showError(error);
            }
        });
    }

    protected void onMigrate() {
        Command onMigrateCommand = () -> {
            if (this.isDirty(this.getCurrentDiagramHash())) {
                this.saveAndMigrate();
            } else {
                this.migrate();
            }
        };
        this.popupUtil.showConfirmPopup(this.getTranslationService().getValue("editor.actions.migrateTitle"), this.getTranslationService().getValue("editor.actions.migrateWarning"), InlineNotification.InlineNotificationType.WARNING, this.getTranslationService().getValue("editor.actions.migrate"), Button.ButtonStyleType.PRIMARY, this.getTranslationService().getValue("editor.actions.migrateConfirmAction"), onMigrateCommand);
    }

    private void saveAndMigrate() {
        this.isMigrating = true;
        super.save();
    }

    private void migrate() {
        this.migrateDiagramEvent.fire((Object)new BPMNMigrateDiagramEvent((Path)this.versionRecordManager.getCurrentPath(), this.place));
    }

    protected void onSaveSuccess() {
        super.onSaveSuccess();
        if (this.isMigrating) {
            this.isMigrating = false;
            this.migrate();
        }
    }

    protected void onSaveError(ClientRuntimeError error) {
        this.isMigrating = false;
        super.onSaveError(error);
    }
}

