/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.bpmn.project.factory.impl;

import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.bpmn.BPMNDefinitionSet;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.util.BPMNUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;

@ApplicationScoped
public class BPMNProjectDiagramFactory
extends BindableDiagramFactory<ProjectMetadata, ProjectDiagram> {
    public ProjectDiagram build(String name, ProjectMetadata metadata, Graph<DefinitionSet, ?> graph) {
        this.updateDiagramProperties(name, graph, metadata);
        return new ProjectDiagramImpl(name, graph, metadata);
    }

    public Class<? extends Metadata> getMetadataType() {
        return ProjectMetadata.class;
    }

    protected Class<?> getDefinitionSetType() {
        return BPMNDefinitionSet.class;
    }

    private void updateDiagramProperties(String name, Graph<DefinitionSet, ?> graph, ProjectMetadata metadata) {
        String diagramName;
        String p;
        String projectName;
        Node<Definition<BPMNDiagram>, ?> diagramNode = BPMNProjectDiagramFactory.getFirstDiagramNode(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A BPMN Diagram is expected to be present on BPMN Diagram graphs.");
        }
        BPMNDiagram diagram = (BPMNDiagram)((Definition)diagramNode.getContent()).getDefinition();
        String id = diagram.getDiagramSet().getId().getValue();
        String string = projectName = null != metadata.getProjectName() ? metadata.getProjectName() + "." : "";
        if (null == id || diagram.getDiagramSet().getId().getDefaultValue().equals(id)) {
            diagram.getDiagramSet().getId().setValue(projectName + name);
        }
        if (null == (p = diagram.getDiagramSet().getPackageProperty().getValue())) {
            diagram.getDiagramSet().getPackageProperty().setValue(metadata.getProjectPackage());
        }
        if (null == (diagramName = diagram.getGeneral().getName().getValue())) {
            diagram.getGeneral().getName().setValue(name);
        }
    }

    private static Node<Definition<BPMNDiagram>, ?> getFirstDiagramNode(Graph graph) {
        return BPMNUtils.getFirstDiagramNode((Graph)graph);
    }
}

