/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.factory;

import javax.enterprise.context.ApplicationScoped;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.util.CaseManagementUtils;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.factory.impl.BindableDiagramFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.project.diagram.ProjectDiagram;
import org.kie.workbench.common.stunner.project.diagram.ProjectMetadata;
import org.kie.workbench.common.stunner.project.diagram.impl.ProjectDiagramImpl;

@ApplicationScoped
public class CaseManagementProjectDiagramFactory
extends BindableDiagramFactory<ProjectMetadata, ProjectDiagram> {
    public ProjectDiagram build(String name, ProjectMetadata metadata, Graph<DefinitionSet, ?> graph) {
        this.updateDiagramProperties(name, graph, metadata);
        return new ProjectDiagramImpl(name, graph, metadata);
    }

    public Class<? extends Metadata> getMetadataType() {
        return ProjectMetadata.class;
    }

    protected Class<?> getDefinitionSetType() {
        return CaseManagementDefinitionSet.class;
    }

    private void updateDiagramProperties(String name, Graph<DefinitionSet, ?> graph, ProjectMetadata metadata) {
        String diagramName;
        String p;
        String projectName;
        Node<Definition<CaseManagementDiagram>, ?> diagramNode = this.getFirstDiagramNode(graph);
        if (null == diagramNode) {
            throw new IllegalStateException("A Case Management Diagram is expected to be present on CaseManagementDiagram graphs.");
        }
        CaseManagementDiagram diagram = (CaseManagementDiagram)((Definition)diagramNode.getContent()).getDefinition();
        String id = diagram.getDiagramSet().getId().getValue();
        String string = projectName = null != metadata.getProjectName() ? metadata.getProjectName() + "." : "";
        if (null == id || diagram.getDiagramSet().getId().getDefaultValue().equals(id)) {
            diagram.getDiagramSet().getId().setValue(projectName + name);
        }
        if (this.nil(p = diagram.getDiagramSet().getPackageProperty().getValue())) {
            String metadataPackage = metadata.getProjectPackage();
            if (this.nil(metadataPackage)) {
                diagram.getDiagramSet().getPackageProperty().setValue("org.jbpm");
            } else {
                diagram.getDiagramSet().getPackageProperty().setValue(metadata.getProjectPackage());
            }
        }
        if (this.nil(diagramName = diagram.getDiagramSet().getName().getValue())) {
            diagram.getDiagramSet().getName().setValue(name);
        }
    }

    private Node<Definition<CaseManagementDiagram>, ?> getFirstDiagramNode(Graph graph) {
        return CaseManagementUtils.getFirstDiagramNode(graph);
    }

    private boolean nil(String value) {
        return value == null || value.isEmpty();
    }
}

