/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.definition;

import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDefinition;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.TaskGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskType;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.TaskTypes;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.definition.annotation.Property;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Category;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Labels;
import org.kie.workbench.common.stunner.core.definition.builder.Builder;

public abstract class CaseManagementBaseTask
implements BPMNDefinition {
    @Category
    public static final transient String category = "Activities";
    @Description
    public static final transient String description = "A task is a unit of work - the job to be performed";
    @PropertySet
    @FormField
    @Valid
    protected TaskGeneralSet general;
    @Property
    protected TaskType taskType;
    @PropertySet
    @FormField(afterElement="general")
    @Valid
    protected BackgroundSet backgroundSet;
    @PropertySet
    protected FontSet fontSet;
    @PropertySet
    protected SimulationSet simulationSet;
    @PropertySet
    protected RectangleDimensionsSet dimensionsSet;
    @Labels
    protected final Set<String> labels = new HashSet<String>(){
        {
            this.add("activity");
        }
    };

    protected CaseManagementBaseTask(TaskTypes type) {
        this.taskType = new TaskType(type);
    }

    public CaseManagementBaseTask(@MapsTo(value="general") TaskGeneralSet general, @MapsTo(value="backgroundSet") BackgroundSet backgroundSet, @MapsTo(value="fontSet") FontSet fontSet, @MapsTo(value="dimensionsSet") RectangleDimensionsSet dimensionsSet, @MapsTo(value="simulationSet") SimulationSet simulationSet, @MapsTo(value="taskType") TaskType taskType) {
        this.general = general;
        this.backgroundSet = backgroundSet;
        this.fontSet = fontSet;
        this.dimensionsSet = dimensionsSet;
        this.simulationSet = simulationSet;
        this.taskType = taskType;
    }

    public String getCategory() {
        return category;
    }

    public String getDescription() {
        return description;
    }

    public Set<String> getLabels() {
        return this.labels;
    }

    public TaskGeneralSet getGeneral() {
        return this.general;
    }

    public void setGeneral(TaskGeneralSet general) {
        this.general = general;
    }

    public BackgroundSet getBackgroundSet() {
        return this.backgroundSet;
    }

    public void setBackgroundSet(BackgroundSet backgroundSet) {
        this.backgroundSet = backgroundSet;
    }

    public FontSet getFontSet() {
        return this.fontSet;
    }

    public void setFontSet(FontSet fontSet) {
        this.fontSet = fontSet;
    }

    public TaskType getTaskType() {
        return this.taskType;
    }

    public void setTaskType(TaskType taskType) {
        this.taskType = taskType;
    }

    public SimulationSet getSimulationSet() {
        return this.simulationSet;
    }

    public void setSimulationSet(SimulationSet simulationSet) {
        this.simulationSet = simulationSet;
    }

    public RectangleDimensionsSet getDimensionsSet() {
        return this.dimensionsSet;
    }

    public void setDimensionsSet(RectangleDimensionsSet dimensionsSet) {
        this.dimensionsSet = dimensionsSet;
    }

    @NonPortable
    static abstract class BaseTaskBuilder<T extends CaseManagementBaseTask>
    implements Builder<T> {
        public static final String COLOR = "#00ff00";
        public static final Double WIDTH = 100.0;
        public static final Double HEIGHT = 50.0;
        public static final Double BORDER_SIZE = 1.0;
        public static final String BORDER_COLOR = "#000000";

        BaseTaskBuilder() {
        }
    }
}

