/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.stunner.cm.definition.factory;

import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;
import java.util.LinkedHashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.factory.ModelFactoryGenerator")
@ApplicationScoped
public class CaseManagementDefinitionSetModelFactoryImpl extends org.kie.workbench.common.stunner.core.factory.definition.AbstractTypeDefinitionFactory<Object> {

    private static final Set<Class<?>> SUPPORTED_DEF_CLASSES = new LinkedHashSet<Class<?>>() {{

            add( org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram.class );
            add( org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess.class );
            add( org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess.class );
            add( org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess.class );
            add( org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet.class );

    }};

    public CaseManagementDefinitionSetModelFactoryImpl() {
    }

    @Override
    public Set<Class<?>> getAcceptedClasses() {
        return SUPPORTED_DEF_CLASSES;
    }

    @Override
    public Object build( final Class<?> clazz ) {


            if ( org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram.class.equals( clazz ) ) {

                return new org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram();

            }


            if ( org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess.class.equals( clazz ) ) {

                return new org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess();

            }


            if ( org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess.class.equals( clazz ) ) {

                return new org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess();

            }


            if ( org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess.class.equals( clazz ) ) {

                return new org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess();

            }


            if ( org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet.class.equals( clazz ) ) {

                return new org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet.CaseManagementDefinitionSetBuilder().build();

            }


        throw new RuntimeException( "This factory [" + this.getClass().getName() + "] " +
            "should provide a definition for [" + clazz + "]" );
    }

}
