/*
* Copyright 2017 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.kie.workbench.common.stunner.cm.definition.formBuilder.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;

import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.building.FormGenerationResourcesProvider;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FieldElement;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FormElement;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;

@Generated("org.kie.workbench.common.forms.adf.processors.FormDefinitionsProcessor")
@ApplicationScoped
public class ModuleFormGenerationResourcesProvider implements FormGenerationResourcesProvider {

    private Map<String, FormDefinitionSettings> definitionSettings = new HashMap<>();

    private Map<String, FieldStatusModifier> fieldStatusModifiers = new HashMap<>();

    private Map<String, String> fieldStatusModifiersReferences = new HashMap<>();

    public ModuleFormGenerationResourcesProvider() {
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess", new org_kie_workbench_common_stunner_cm_definition_EmbeddedSubprocessFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess", new org_kie_workbench_common_stunner_cm_definition_ReusableSubprocessFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram", new org_kie_workbench_common_stunner_cm_definition_CaseManagementDiagramFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess", new org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessFormBuilder().getSettings() );
    }

    @Override
    public Map<String, FormDefinitionSettings> getDefinitionSettings() {
        return definitionSettings;
    }

    @Override
    public Map<String, FieldStatusModifier> getFieldModifiers() {
        return fieldStatusModifiers;
    }

    @Override
    public Map<String, String> getFieldModifierReferences() {
        return fieldStatusModifiersReferences;
    }

    class org_kie_workbench_common_stunner_cm_definition_EmbeddedSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.EmbeddedSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_processData() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.subProcess.execution.EmbeddedSubprocessExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_processData() {
            FieldElement field = new FieldElement( "processData", "processData", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "executionSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_ReusableSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_dataIOSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dataIOSet() {
            FieldElement field = new FieldElement( "dataIOSet", "dataIOSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "executionSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_CaseManagementDiagramFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_diagramSet() );
            elements.add( getFormElement_processData() );
            elements.add( getFormElement_caseManagementSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_diagramSet() {
            FieldElement field = new FieldElement( "diagramSet", "diagramSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_processData() {
            FieldElement field = new FieldElement( "processData", "processData", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "diagramSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_caseManagementSet() {
            FieldElement field = new FieldElement( "caseManagementSet", "caseManagementSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "processData" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_processData() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_processData() {
            FieldElement field = new FieldElement( "processData", "processData", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "executionSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

}
