/*
 * Copyright 2018 Red Hat, Inc. and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.kie.workbench.common.stunner.cm.definition;

import javax.validation.Valid;

import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.stunner.bpmn.definition.BaseReusableSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOModel;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.cm.definition.property.task.BaseCaseManagementReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.util.HashUtil;


public abstract class BaseCaseManagementReusableSubprocess<E extends BaseCaseManagementReusableSubprocessTaskExecutionSet>
        extends BaseReusableSubprocess<E> implements DataIOModel {

    @PropertySet
    @FormField
    @Valid
    protected DataIOSet dataIOSet;

    public BaseCaseManagementReusableSubprocess(final @MapsTo("general") BPMNGeneralSet general,
                                                final @MapsTo("dataIOSet") DataIOSet dataIOSet,
                                                final @MapsTo("backgroundSet") BackgroundSet backgroundSet,
                                                final @MapsTo("fontSet") FontSet fontSet,
                                                final @MapsTo("dimensionsSet") RectangleDimensionsSet dimensionsSet,
                                                final @MapsTo("simulationSet") SimulationSet simulationSet) {
        super(general,
              backgroundSet,
              fontSet,
              dimensionsSet,
              simulationSet);
        this.dataIOSet = dataIOSet;
    }

    @Override
    protected void initLabels() {
        super.initLabels();
        labels.add("cm_activity");
        labels.remove("cm_stage");
    }

    @Override
    public boolean hasInputVars() {
        return true;
    }

    @Override
    public boolean isSingleInputVar() {
        return false;
    }

    @Override
    public boolean hasOutputVars() {
        return true;
    }

    @Override
    public boolean isSingleOutputVar() {
        return false;
    }

    public DataIOSet getDataIOSet() {
        return dataIOSet;
    }

    public void setDataIOSet(final DataIOSet dataIOSet) {
        this.dataIOSet = dataIOSet;
    }

    @Override
    public abstract E getExecutionSet();

    @Override
    public abstract void setExecutionSet(E executionSet);

    @Override
    public int hashCode() {
        return HashUtil.combineHashCodes(super.hashCode(),
                                         dataIOSet.hashCode());
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof BaseCaseManagementReusableSubprocess) {
            BaseCaseManagementReusableSubprocess other = (BaseCaseManagementReusableSubprocess) o;

            return super.equals(other) &&
                    dataIOSet.equals(other.dataIOSet);
        }
        return false;
    }
}
