/*
* Copyright 2017 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/
package org.kie.workbench.common.stunner.cm.definition.formBuilder.provider;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Generated;
import javax.enterprise.context.ApplicationScoped;

import org.kie.workbench.common.forms.adf.definitions.settings.ColSpan;
import org.kie.workbench.common.forms.adf.service.building.FieldStatusModifier;
import org.kie.workbench.common.forms.adf.service.building.FormGenerationResourcesProvider;
import org.kie.workbench.common.forms.adf.service.definitions.FormDefinitionSettings;
import org.kie.workbench.common.forms.adf.service.definitions.I18nSettings;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FieldElement;
import org.kie.workbench.common.forms.adf.service.definitions.elements.FormElement;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutColumnDefinition;
import org.kie.workbench.common.forms.adf.service.definitions.layout.LayoutDefinition;
import org.kie.workbench.common.forms.model.FieldDefinition;
import org.kie.workbench.common.forms.model.TypeKind;
import org.kie.workbench.common.forms.model.impl.TypeInfoImpl;

@Generated("org.kie.workbench.common.forms.adf.processors.FormDefinitionsProcessor")
@ApplicationScoped
public class ModuleFormGenerationResourcesProvider implements FormGenerationResourcesProvider {

    private Map<String, FormDefinitionSettings> definitionSettings = new HashMap<>();

    private Map<String, FieldStatusModifier> fieldStatusModifiers = new HashMap<>();

    private Map<String, String> fieldStatusModifiersReferences = new HashMap<>();

    public ModuleFormGenerationResourcesProvider() {
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess", new org_kie_workbench_common_stunner_cm_definition_CaseReusableSubprocessFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess", new org_kie_workbench_common_stunner_cm_definition_ProcessReusableSubprocessFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet", new org_kie_workbench_common_stunner_cm_definition_property_task_ProcessReusableSubprocessTaskExecutionSetFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram", new org_kie_workbench_common_stunner_cm_definition_CaseManagementDiagramFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet", new org_kie_workbench_common_stunner_cm_definition_property_task_CaseReusableSubprocessTaskExecutionSetFormBuilder().getSettings() );
        definitionSettings.put( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess", new org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessFormBuilder().getSettings() );
        fieldStatusModifiers.put( "org_kie_workbench_common_stunner_cm_definition_property_subprocess_IsCase_FieldStatusModifier", new org_kie_workbench_common_stunner_cm_definition_property_subprocess_IsCase_FieldStatusModifier() );
    }

    @Override
    public Map<String, FormDefinitionSettings> getDefinitionSettings() {
        return definitionSettings;
    }

    @Override
    public Map<String, FieldStatusModifier> getFieldModifiers() {
        return fieldStatusModifiers;
    }

    @Override
    public Map<String, String> getFieldModifierReferences() {
        return fieldStatusModifiersReferences;
    }

    class org_kie_workbench_common_stunner_cm_definition_CaseReusableSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_dataIOSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dataIOSet() {
            FieldElement field = new FieldElement( "dataIOSet", "dataIOSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_ProcessReusableSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_dataIOSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_dataIOSet() {
            FieldElement field = new FieldElement( "dataIOSet", "dataIOSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_property_task_ProcessReusableSubprocessTaskExecutionSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_calledElement() );
            elements.add( getFormElement_isCase() );
            elements.add( getFormElement_independent() );
            elements.add( getFormElement_waitForCompletion() );
            elements.add( getFormElement_isAsync() );
            elements.add( getFormElement_onEntryAction() );
            elements.add( getFormElement_onExitAction() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_calledElement() {
            FieldElement field = new FieldElement( "calledElement", "calledElement.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.type.ListBoxFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "org.kie.workbench.common.forms.adf.definitions.annotations.field.selector.SelectorDataProvider", "remote:org.kie.workbench.common.stunner.bpmn.backend.dataproviders.CalledElementFormProvider" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.calledElement", "org_kie_workbench_common_stunner_bpmn_definition_property_task_CalledElement_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_isCase() {
            FieldElement field = new FieldElement( "isCase", "isCase.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getLayoutSettings().setAfterElement( "calledElement" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.isCase", "org_kie_workbench_common_stunner_cm_definition_property_subprocess_IsCase_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_independent() {
            FieldElement field = new FieldElement( "independent", "independent.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "isCase" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.independent", "org_kie_workbench_common_stunner_bpmn_definition_property_task_Independent_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_waitForCompletion() {
            FieldElement field = new FieldElement( "waitForCompletion", "waitForCompletion.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "independent" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.waitForCompletion", "org_kie_workbench_common_stunner_bpmn_definition_property_task_WaitForCompletion_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_isAsync() {
            FieldElement field = new FieldElement( "isAsync", "isAsync.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "waitForCompletion" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.isAsync", "org_kie_workbench_common_stunner_bpmn_definition_property_task_IsAsync_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_onEntryAction() {
            FieldElement field = new FieldElement( "onEntryAction", "onEntryAction.value", new TypeInfoImpl( TypeKind.BASE, "org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "mode", "ACTION_SCRIPT" );
            field.getLayoutSettings().setAfterElement( "isAsync" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.onEntryAction", "org_kie_workbench_common_stunner_bpmn_definition_property_task_OnEntryAction_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_onExitAction() {
            FieldElement field = new FieldElement( "onExitAction", "onExitAction.value", new TypeInfoImpl( TypeKind.BASE, "org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "mode", "ACTION_SCRIPT" );
            field.getLayoutSettings().setAfterElement( "onEntryAction" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet.onExitAction", "org_kie_workbench_common_stunner_bpmn_definition_property_task_OnExitAction_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_CaseManagementDiagramFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_diagramSet() );
            elements.add( getFormElement_processData() );
            elements.add( getFormElement_caseManagementSet() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_diagramSet() {
            FieldElement field = new FieldElement( "diagramSet", "diagramSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_processData() {
            FieldElement field = new FieldElement( "processData", "processData", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "diagramSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_caseManagementSet() {
            FieldElement field = new FieldElement( "caseManagementSet", "caseManagementSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.cm.CaseManagementSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "processData" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_property_task_CaseReusableSubprocessTaskExecutionSetFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_calledElement() );
            elements.add( getFormElement_isCase() );
            elements.add( getFormElement_independent() );
            elements.add( getFormElement_waitForCompletion() );
            elements.add( getFormElement_isAsync() );
            elements.add( getFormElement_onEntryAction() );
            elements.add( getFormElement_onExitAction() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_calledElement() {
            FieldElement field = new FieldElement( "calledElement", "calledElement.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.String", false) );
            field.setPreferredType( org.kie.workbench.common.forms.fields.shared.fieldTypes.basic.selectors.listBox.type.ListBoxFieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.CalledElement.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "org.kie.workbench.common.forms.adf.definitions.annotations.field.selector.SelectorDataProvider", "remote:org.kie.workbench.common.stunner.cm.backend.dataproviders.CaseCalledElementFormProvider" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.calledElement", "org_kie_workbench_common_stunner_bpmn_definition_property_task_CalledElement_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_isCase() {
            FieldElement field = new FieldElement( "isCase", "isCase.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase.helpMessage");
            field.setRequired( false );
            field.setReadOnly( true );
            field.getLayoutSettings().setAfterElement( "calledElement" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.isCase", "org_kie_workbench_common_stunner_cm_definition_property_subprocess_IsCase_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_independent() {
            FieldElement field = new FieldElement( "independent", "independent.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.Independent.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "isCase" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.independent", "org_kie_workbench_common_stunner_bpmn_definition_property_task_Independent_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_waitForCompletion() {
            FieldElement field = new FieldElement( "waitForCompletion", "waitForCompletion.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.WaitForCompletion.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "independent" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.waitForCompletion", "org_kie_workbench_common_stunner_bpmn_definition_property_task_WaitForCompletion_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_isAsync() {
            FieldElement field = new FieldElement( "isAsync", "isAsync.value", new TypeInfoImpl( TypeKind.BASE, "java.lang.Boolean", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.IsAsync.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getLayoutSettings().setAfterElement( "waitForCompletion" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.isAsync", "org_kie_workbench_common_stunner_bpmn_definition_property_task_IsAsync_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_onEntryAction() {
            FieldElement field = new FieldElement( "onEntryAction", "onEntryAction.value", new TypeInfoImpl( TypeKind.BASE, "org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.OnEntryAction.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "mode", "ACTION_SCRIPT" );
            field.getLayoutSettings().setAfterElement( "isAsync" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.onEntryAction", "org_kie_workbench_common_stunner_bpmn_definition_property_task_OnEntryAction_FieldStatusModifier" );
            return field;
        }

        private FormElement getFormElement_onExitAction() {
            FieldElement field = new FieldElement( "onExitAction", "onExitAction.value", new TypeInfoImpl( TypeKind.BASE, "org.kie.workbench.common.stunner.bpmn.definition.property.task.ScriptTypeListValue", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.OnExitAction.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "mode", "ACTION_SCRIPT" );
            field.getLayoutSettings().setAfterElement( "onEntryAction" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            fieldStatusModifiersReferences.put( "org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet.onExitAction", "org_kie_workbench_common_stunner_bpmn_definition_property_task_OnExitAction_FieldStatusModifier" );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_AdHocSubprocessFormBuilder {
        public FormDefinitionSettings getSettings() {
            FormDefinitionSettings settings = new FormDefinitionSettings( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess" );
            settings.setI18nSettings( new I18nSettings( "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess" ) );
            settings.setLayout( new LayoutDefinition( new LayoutColumnDefinition[] { new LayoutColumnDefinition( ColSpan.AUTO ) } ) );
            List<FormElement> elements = new ArrayList<FormElement>();
            elements.add( getFormElement_general() );
            elements.add( getFormElement_executionSet() );
            elements.add( getFormElement_processData() );
            settings.getFormElements().addAll( elements );
            return settings;
        }

        private FormElement getFormElement_general() {
            FieldElement field = new FieldElement( "general", "general", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_executionSet() {
            FieldElement field = new FieldElement( "executionSet", "executionSet", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.task.AdHocSubprocessTaskExecutionSet.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "general" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

        private FormElement getFormElement_processData() {
            FieldElement field = new FieldElement( "processData", "processData", new TypeInfoImpl( TypeKind.OBJECT, "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData", false) );
            field.setPreferredType( org.kie.workbench.common.forms.model.FieldType.class );
            field.setLabelKey( "org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.label" );
            field.setHelpMessageKey("org.kie.workbench.common.stunner.bpmn.definition.property.variables.ProcessData.helpMessage");
            field.setRequired( false );
            field.setReadOnly( false );
            field.getParams().put( "nestedFormContainer", "COLLAPSIBLE" );
            field.getLayoutSettings().setAfterElement( "executionSet" );
            field.getLayoutSettings().setHorizontalSpan( 1 );
            field.getLayoutSettings().setVerticalSpan( 1 );
            field.getLayoutSettings().setWrap( false );
            return field;
        }

    }

    class org_kie_workbench_common_stunner_cm_definition_property_subprocess_IsCase_FieldStatusModifier implements FieldStatusModifier<org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase> {
        @Override
        public void modifyFieldStatus( FieldDefinition field, org.kie.workbench.common.stunner.cm.definition.property.subprocess.IsCase model ) {
            if ( model != null ) {
            }
        }
    }

}
