/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.factory;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactory;
import org.kie.workbench.common.stunner.bpmn.factory.BPMNGraphFactoryImpl;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.factory.CaseManagementGraphFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.impl.CompositeCommand;
import org.kie.workbench.common.stunner.core.factory.graph.ElementFactory;
import org.kie.workbench.common.stunner.core.factory.impl.AbstractGraphFactory;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.EmptyRulesCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
public class CaseManagementGraphFactoryImpl
extends AbstractGraphFactory
implements CaseManagementGraphFactory {
    private final DefinitionManager definitionManager;
    private final RuleManager ruleManager;
    private final GraphIndexBuilder<?> indexBuilder;
    private final GraphCommandManager graphCommandManager;
    private final GraphCommandFactory graphCommandFactory;
    private final FactoryManager factoryManager;
    private final BPMNGraphFactory bpmnGraphFactory;
    private Class<? extends BPMNDiagram> diagramType;

    protected CaseManagementGraphFactoryImpl() {
        this(null, null, null, null, null, null, null);
    }

    @Inject
    public CaseManagementGraphFactoryImpl(DefinitionManager definitionManager, FactoryManager factoryManager, RuleManager ruleManager, GraphCommandManager graphCommandManager, GraphCommandFactory graphCommandFactory, GraphIndexBuilder<?> indexBuilder, BPMNGraphFactoryImpl graphFactory) {
        this.definitionManager = definitionManager;
        this.factoryManager = factoryManager;
        this.ruleManager = ruleManager;
        this.graphCommandManager = graphCommandManager;
        this.graphCommandFactory = graphCommandFactory;
        this.indexBuilder = indexBuilder;
        this.diagramType = CaseManagementDiagram.class;
        this.bpmnGraphFactory = graphFactory;
    }

    @PostConstruct
    public void init() {
        this.bpmnGraphFactory.setDiagramType(CaseManagementDiagram.class);
    }

    public void setDiagramType(Class<? extends BPMNDiagram> diagramType) {
        this.diagramType = diagramType;
    }

    public Class<? extends ElementFactory> getFactoryType() {
        return CaseManagementGraphFactory.class;
    }

    public Graph<DefinitionSet, Node> build(String uuid, String definitionSetId) {
        Graph graph = super.build(uuid, definitionSetId);
        List<Command> commands = this.buildInitialisationCommands();
        CompositeCommand.Builder commandBuilder = new CompositeCommand.Builder();
        commands.forEach(arg_0 -> ((CompositeCommand.Builder)commandBuilder).addCommand(arg_0));
        this.graphCommandManager.execute((Object)this.createGraphContext(graph), (Command)commandBuilder.build());
        return graph;
    }

    public boolean accepts(String source) {
        return true;
    }

    protected DefinitionManager getDefinitionManager() {
        return this.definitionManager;
    }

    protected List<Command> buildInitialisationCommands() {
        ArrayList<Command> commands = new ArrayList<Command>();
        Node diagramNode = (Node)this.factoryManager.newElement(UUID.uuid(), this.diagramType);
        commands.add((Command)this.graphCommandFactory.addNode(diagramNode));
        return commands;
    }

    protected GraphCommandExecutionContext createGraphContext(Graph graph) {
        return new EmptyRulesCommandExecutionContext(this.definitionManager, this.factoryManager, this.ruleManager, this.indexBuilder.build(graph));
    }
}

