/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.definition;

import java.util.HashSet;
import java.util.Set;
import javax.validation.Valid;
import org.jboss.errai.common.client.api.annotations.MapsTo;
import org.jboss.errai.common.client.api.annotations.NonPortable;
import org.jboss.errai.common.client.api.annotations.Portable;
import org.jboss.errai.databinding.client.api.Bindable;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormDefinition;
import org.kie.workbench.common.forms.adf.definitions.annotations.FormField;
import org.kie.workbench.common.forms.adf.definitions.settings.FieldPolicy;
import org.kie.workbench.common.stunner.bpmn.definition.BaseSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.background.BackgroundSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOModel;
import org.kie.workbench.common.stunner.bpmn.definition.property.dataio.DataIOSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.dimensions.RectangleDimensionsSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.font.FontSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.BPMNGeneralSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.simulation.SimulationSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.ReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.core.definition.annotation.Definition;
import org.kie.workbench.common.stunner.core.definition.annotation.Description;
import org.kie.workbench.common.stunner.core.definition.annotation.PropertySet;
import org.kie.workbench.common.stunner.core.definition.annotation.definition.Title;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.util.HashUtil;

@Portable
@Bindable
@Definition(graphFactory=NodeFactory.class, builder=ReusableSubprocessBuilder.class)
@FormDefinition(startElement="general", policy=FieldPolicy.ONLY_MARKED)
public class ReusableSubprocess
extends BaseSubprocess
implements DataIOModel {
    @Title
    public static final transient String title = "Reusable Sub-Process";
    @Description
    public static final transient String description = "A reusable Sub-Process. It can be used to invoke another process.";
    @PropertySet
    @FormField(afterElement="general")
    @Valid
    protected ReusableSubprocessTaskExecutionSet executionSet;
    @PropertySet
    @FormField(afterElement="executionSet")
    @Valid
    protected DataIOSet dataIOSet;

    public ReusableSubprocess() {
    }

    public ReusableSubprocess(@MapsTo(value="general") BPMNGeneralSet general, @MapsTo(value="executionSet") ReusableSubprocessTaskExecutionSet executionSet, @MapsTo(value="dataIOSet") DataIOSet dataIOSet, @MapsTo(value="backgroundSet") BackgroundSet backgroundSet, @MapsTo(value="fontSet") FontSet fontSet, @MapsTo(value="dimensionsSet") RectangleDimensionsSet dimensionsSet, @MapsTo(value="simulationSet") SimulationSet simulationSet) {
        super(general, backgroundSet, fontSet, dimensionsSet, simulationSet);
        this.executionSet = executionSet;
        this.dataIOSet = dataIOSet;
    }

    protected Set<String> makeLabels() {
        return new HashSet<String>(){
            {
                this.add("all");
                this.add("sequence_start");
                this.add("sequence_end");
                this.add("messageflow_start");
                this.add("messageflow_end");
                this.add("to_task_event");
                this.add("from_task_event");
                this.add("fromtoall");
                this.add("ActivitiesMorph");
                this.add("cm_activity");
            }
        };
    }

    public boolean hasInputVars() {
        return true;
    }

    public boolean isSingleInputVar() {
        return false;
    }

    public boolean hasOutputVars() {
        return true;
    }

    public boolean isSingleOutputVar() {
        return false;
    }

    public String getTitle() {
        return title;
    }

    public ReusableSubprocessTaskExecutionSet getExecutionSet() {
        return this.executionSet;
    }

    public DataIOSet getDataIOSet() {
        return this.dataIOSet;
    }

    public void setExecutionSet(ReusableSubprocessTaskExecutionSet executionSet) {
        this.executionSet = executionSet;
    }

    public void setDataIOSet(DataIOSet dataIOSet) {
        this.dataIOSet = dataIOSet;
    }

    public int hashCode() {
        return HashUtil.combineHashCodes((int[])new int[]{super.hashCode(), this.executionSet.hashCode(), this.dataIOSet.hashCode()});
    }

    public boolean equals(Object o) {
        if (o instanceof ReusableSubprocess) {
            ReusableSubprocess other = (ReusableSubprocess)((Object)o);
            return super.equals((Object)other) && this.executionSet.equals((Object)other.executionSet) && this.dataIOSet.equals((Object)other.dataIOSet);
        }
        return false;
    }

    @NonPortable
    public static class ReusableSubprocessBuilder
    extends BaseSubprocess.BaseSubprocessBuilder<ReusableSubprocess> {
        public ReusableSubprocess build() {
            return new ReusableSubprocess(new BPMNGeneralSet("Subprocess"), new ReusableSubprocessTaskExecutionSet(), new DataIOSet(), new BackgroundSet("#fafad2", "#000000", BORDER_SIZE), new FontSet(), new RectangleDimensionsSet(WIDTH, HEIGHT), new SimulationSet());
        }
    }
}

