/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.stunner.cm.definition.adapter.binding;

import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.HashSet;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionSetAdapterImpl;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionSetAdapterBindings;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionSetAdapterWrapper;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.definitionset.BindableDefinitionSetAdapterGenerator")
@ApplicationScoped
public class CaseManagementDefinitionSetDefinitionSetAdapterImpl extends DefinitionSetAdapterWrapper<Object, BindableDefinitionSetAdapter<Object>> {

    @Inject
    public CaseManagementDefinitionSetDefinitionSetAdapterImpl(StunnerTranslationService translationService) {
        super(BindableDefinitionSetAdapterImpl.create(translationService));
    }

    @PostConstruct
    public void init() {
        adapter.setBindings(org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet.class, new DefinitionSetAdapterBindings() .setGraphFactory(org.kie.workbench.common.stunner.cm.factory.CaseManagementGraphFactory.class).setDefinitionIds(new HashSet<>(Arrays.asList("org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram","org.kie.workbench.common.stunner.bpmn.definition.Lane","org.kie.workbench.common.stunner.bpmn.definition.NoneTask","org.kie.workbench.common.stunner.cm.definition.UserTask","org.kie.workbench.common.stunner.bpmn.definition.ScriptTask","org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask","org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent","org.kie.workbench.common.stunner.bpmn.definition.StartSignalEvent","org.kie.workbench.common.stunner.bpmn.definition.StartTimerEvent","org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent","org.kie.workbench.common.stunner.bpmn.definition.EndTerminateEvent","org.kie.workbench.common.stunner.bpmn.definition.IntermediateTimerEvent","org.kie.workbench.common.stunner.bpmn.definition.ParallelGateway","org.kie.workbench.common.stunner.bpmn.definition.ExclusiveGateway","org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess","org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess","org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess","org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow"))).setQualifier(new org.kie.workbench.common.stunner.cm.qualifiers.CaseManagementEditor() {
                    @Override
                    public Class<? extends Annotation> annotationType() {
                        return org.kie.workbench.common.stunner.cm.qualifiers.CaseManagementEditor.class;
                }}));
    }

}
