/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.stunner.cm.definition.adapter.binding;

import java.util.Arrays;
import java.util.HashMap;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.HasInheritance;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.DefinitionAdapterWrapper;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableDefinitionAdapterImpl;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.DefinitionAdapterBindings;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.definition.BindableDefinitionAdapterGenerator")
@ApplicationScoped
public class CaseManagementDefinitionSetDefinitionAdapterImpl extends DefinitionAdapterWrapper<Object, BindableDefinitionAdapter<Object>> implements HasInheritance {

    protected CaseManagementDefinitionSetDefinitionAdapterImpl() {
    }

    @Inject
    public CaseManagementDefinitionSetDefinitionAdapterImpl(StunnerTranslationService translationService, BindableAdapterFunctions functions) {
        super(BindableDefinitionAdapterImpl.create(translationService, functions, new HashMap<>(5)));
    }

    @PostConstruct
    public void init() {
            adapter.addBindings(org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram.class, new DefinitionAdapterBindings().setBaseType(java.lang.Object.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("labels").setCategoryField("category").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("processData.processVariables","advancedData.metaDataAttributes","advancedData.globalVariables","caseManagementSet.caseIdPrefix","caseManagementSet.caseRoles","caseManagementSet.caseFileVariables","dimensionsSet.width","dimensionsSet.height","diagramSet.name","diagramSet.documentation","diagramSet.id","diagramSet.packageProperty","diagramSet.processType","diagramSet.version","diagramSet.adHoc","diagramSet.processInstanceDescription","diagramSet.imports","diagramSet.executable","diagramSet.slaDueDate","backgroundSet.bgColor","backgroundSet.borderColor","backgroundSet.borderSize","fontSet.fontFamily","fontSet.fontColor","fontSet.fontSize","fontSet.fontBorderSize","fontSet.fontBorderColor")).setTypedPropertyFields(Arrays.asList(true,false,false,false,false,false,false,false,false,false,false,true,false,true,false,true,false,false,false,false,false,false,false,false,false,false,false)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.stunner.cm.definition.UserTask.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.stunner.bpmn.definition.BaseTask.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("labels").setCategoryField("category").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("executionSet.taskName","executionSet.subject","executionSet.actors","executionSet.groupid","executionSet.assignmentsinfo","executionSet.reassignmentsInfo","executionSet.notificationsInfo","executionSet.isAsync","executionSet.skippable","executionSet.priority","executionSet.description","executionSet.createdBy","executionSet.adHocAutostart","executionSet.isMultipleInstance","executionSet.multipleInstanceExecutionMode","executionSet.multipleInstanceCollectionInput","executionSet.multipleInstanceDataInput","executionSet.multipleInstanceCollectionOutput","executionSet.multipleInstanceDataOutput","executionSet.multipleInstanceCompletionCondition","executionSet.onEntryAction","executionSet.onExitAction","executionSet.content","executionSet.slaDueDate","general.name","general.documentation","taskType","backgroundSet.bgColor","backgroundSet.borderColor","backgroundSet.borderSize","fontSet.fontFamily","fontSet.fontColor","fontSet.fontSize","fontSet.fontBorderSize","fontSet.fontBorderColor","simulationSet.min","simulationSet.max","simulationSet.mean","simulationSet.timeUnit","simulationSet.standardDeviation","simulationSet.distributionType","simulationSet.quantity","simulationSet.workingHours","simulationSet.unitCost","simulationSet.currency","dimensionsSet.width","dimensionsSet.height")).setTypedPropertyFields(Arrays.asList(false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.stunner.bpmn.definition.BaseNonContainerSubprocess.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("labels").setCategoryField("category").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("executionSet.calledElement","executionSet.isCase","executionSet.independent","executionSet.abortParent","executionSet.waitForCompletion","executionSet.adHocAutostart","executionSet.isMultipleInstance","executionSet.multipleInstanceExecutionMode","executionSet.multipleInstanceCollectionInput","executionSet.multipleInstanceDataInput","executionSet.multipleInstanceCollectionOutput","executionSet.multipleInstanceDataOutput","executionSet.multipleInstanceCompletionCondition","executionSet.onEntryAction","executionSet.onExitAction","executionSet.isAsync","executionSet.slaDueDate","dataIOSet.assignmentsinfo","general.name","general.documentation","backgroundSet.bgColor","backgroundSet.borderColor","backgroundSet.borderSize","fontSet.fontFamily","fontSet.fontColor","fontSet.fontSize","fontSet.fontBorderSize","fontSet.fontBorderColor","simulationSet.min","simulationSet.max","simulationSet.mean","simulationSet.timeUnit","simulationSet.standardDeviation","simulationSet.distributionType","simulationSet.quantity","simulationSet.workingHours","simulationSet.unitCost","simulationSet.currency","dimensionsSet.width","dimensionsSet.height")).setTypedPropertyFields(Arrays.asList(false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.stunner.bpmn.definition.BaseNonContainerSubprocess.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("labels").setCategoryField("category").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("executionSet.calledElement","executionSet.isCase","executionSet.independent","executionSet.abortParent","executionSet.waitForCompletion","executionSet.adHocAutostart","executionSet.isMultipleInstance","executionSet.multipleInstanceExecutionMode","executionSet.multipleInstanceCollectionInput","executionSet.multipleInstanceDataInput","executionSet.multipleInstanceCollectionOutput","executionSet.multipleInstanceDataOutput","executionSet.multipleInstanceCompletionCondition","executionSet.onEntryAction","executionSet.onExitAction","executionSet.isAsync","executionSet.slaDueDate","dataIOSet.assignmentsinfo","general.name","general.documentation","backgroundSet.bgColor","backgroundSet.borderColor","backgroundSet.borderSize","fontSet.fontFamily","fontSet.fontColor","fontSet.fontSize","fontSet.fontBorderSize","fontSet.fontBorderColor","simulationSet.min","simulationSet.max","simulationSet.mean","simulationSet.timeUnit","simulationSet.standardDeviation","simulationSet.distributionType","simulationSet.quantity","simulationSet.workingHours","simulationSet.unitCost","simulationSet.currency","dimensionsSet.width","dimensionsSet.height")).setTypedPropertyFields(Arrays.asList(false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
            adapter.addBindings(org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess.class, new DefinitionAdapterBindings().setBaseType(org.kie.workbench.common.stunner.bpmn.definition.BaseSubprocess.class).setGraphFactory(org.kie.workbench.common.stunner.core.factory.graph.NodeFactory.class).setIdField(null).setTitleField(null).setLabelsField("labels").setCategoryField("category").setDescriptionField(null).setPropertiesFieldNames(Arrays.asList("executionSet.adHocActivationCondition","executionSet.adHocCompletionCondition","executionSet.adHocOrdering","executionSet.adHocAutostart","executionSet.onEntryAction","executionSet.onExitAction","executionSet.isAsync","executionSet.slaDueDate","processData.processVariables","general.name","general.documentation","backgroundSet.bgColor","backgroundSet.borderColor","backgroundSet.borderSize","fontSet.fontFamily","fontSet.fontColor","fontSet.fontSize","fontSet.fontBorderSize","fontSet.fontBorderColor","simulationSet.min","simulationSet.max","simulationSet.mean","simulationSet.timeUnit","simulationSet.standardDeviation","simulationSet.distributionType","simulationSet.quantity","simulationSet.workingHours","simulationSet.unitCost","simulationSet.currency","dimensionsSet.width","dimensionsSet.height")).setTypedPropertyFields(Arrays.asList(true,true,false,false,false,false,false,false,true,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false,false)).setMetaTypes(DefinitionAdapterBindings.PropertyMetaTypes.parse("-1,-1,-1,-1,-1")));
    }

    @Override
    public String getBaseType(Class<?> type) {
        return adapter.getBaseType(type);
    }

    @Override
    public String[] getTypes(String baseType) {
        return adapter.getTypes(baseType);
    }

}