/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.stunner.cm.definition.adapter.binding;

import org.kie.workbench.common.stunner.core.definition.adapter.AbstractDefinitionSetRuleAdapter;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.RuleSetImpl;
import org.kie.workbench.common.stunner.core.rule.context.*;
import org.kie.workbench.common.stunner.core.rule.ext.RuleExtension;
import org.kie.workbench.common.stunner.core.rule.impl.CanConnect;
import org.kie.workbench.common.stunner.core.rule.impl.CanContain;
import org.kie.workbench.common.stunner.core.rule.impl.CanDock;
import org.kie.workbench.common.stunner.core.rule.impl.EdgeOccurrences;
import org.kie.workbench.common.stunner.core.rule.impl.Occurrences;

import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@Generated("org.kie.workbench.common.stunner.core.processors.rule.BindableDefinitionSetRuleAdapterGenerator")
@ApplicationScoped
public class CaseManagementDefinitionSetRuleAdapterImpl extends org.kie.workbench.common.stunner.core.definition.adapter.AbstractDefinitionSetRuleAdapter<org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet> {

        
CanContain  caseManagementDefinitionSetContainmentRule = new CanContain("caseManagementDefinitionSetContainmentRule", "org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet", new HashSet<String>(1) {{
        add( "diagram" );
}});


        
CanContain  caseManagementDiagramContainmentRule = new CanContain("caseManagementDiagramContainmentRule", "org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram", new HashSet<String>(2) {{
        add( "cm_stage" );
        add( "cm_nop" );
}});


        
CanContain  adHocSubprocessContainmentRule = new CanContain("adHocSubprocessContainmentRule", "org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess", new HashSet<String>(4) {{
        add( "cm_activity" );
        add( "IntermediateEventsMorph" );
        add( "GatewaysMorph" );
        add( "EndEventsMorph" );
}});


        
CanContain  laneContainmentRule = new CanContain("laneContainmentRule", "org.kie.workbench.common.stunner.bpmn.definition.Lane", new HashSet<String>(1) {{
        add( "lane_child" );
}});


        
CanDock noneTaskDockingRule = new CanDock("noneTaskDockingRule", "org.kie.workbench.common.stunner.bpmn.definition.NoneTask", new HashSet<String>(1) {{
        add( "IntermediateEventOnActivityBoundary" );
}});


        
CanDock scriptTaskDockingRule = new CanDock("scriptTaskDockingRule", "org.kie.workbench.common.stunner.bpmn.definition.ScriptTask", new HashSet<String>(1) {{
        add( "IntermediateEventOnActivityBoundary" );
}});


        
CanDock businessRuleTaskDockingRule = new CanDock("businessRuleTaskDockingRule", "org.kie.workbench.common.stunner.bpmn.definition.BusinessRuleTask", new HashSet<String>(1) {{
        add( "IntermediateEventOnActivityBoundary" );
}});


        Occurrences caseManagementDefinitionSetCardinalityRule0CardinalityRule = new Occurrences( "caseManagementDefinitionSetCardinalityRule0CardinalityRule", "diagram", 0, 1 );
        Occurrences caseManagementDefinitionSetCardinalityRule1CardinalityRule = new Occurrences( "caseManagementDefinitionSetCardinalityRule1CardinalityRule", "Startevents_all", 0, -1 );
        Occurrences caseManagementDefinitionSetCardinalityRule2CardinalityRule = new Occurrences( "caseManagementDefinitionSetCardinalityRule2CardinalityRule", "Endevents_all", 0, -1 );

    private static final Set<Rule> rules = new HashSet<Rule>(10);
    private RuleSet ruleSet;

    @PostConstruct
    public void init() {
            rules.add(caseManagementDefinitionSetContainmentRule);
            rules.add(caseManagementDiagramContainmentRule);
            rules.add(adHocSubprocessContainmentRule);
            rules.add(laneContainmentRule);
            rules.add(noneTaskDockingRule);
            rules.add(scriptTaskDockingRule);
            rules.add(businessRuleTaskDockingRule);
            rules.add(caseManagementDefinitionSetCardinalityRule0CardinalityRule);
            rules.add(caseManagementDefinitionSetCardinalityRule1CardinalityRule);
            rules.add(caseManagementDefinitionSetCardinalityRule2CardinalityRule);
        ruleSet = new RuleSetImpl("CaseManagementDefinitionSetRuleAdapterImpl", rules);
    }

    @Override
    public RuleSet getRuleSet( final org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet pojo ) {
        return ruleSet;
    }

    @Override
    public boolean accepts( final Class<?> type ) {
        return org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet.class.equals( type );
    }

}
