/*
* Copyright 2016 Red Hat, Inc. and/or its affiliates.
*  
* Licensed under the Apache License, Version 2.0 (the "License");
* you may not use this file except in compliance with the License.
* You may obtain a copy of the License at
*  
*    http://www.apache.org/licenses/LICENSE-2.0
*  
* Unless required by applicable law or agreed to in writing, software
* distributed under the License is distributed on an "AS IS" BASIS,
* WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
* See the License for the specific language governing permissions and
* limitations under the License.
*/

package org.kie.workbench.common.stunner.cm.definition.adapter.binding;

import java.util.HashMap;
import javax.annotation.Generated;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;

import org.kie.workbench.common.stunner.core.definition.adapter.PropertyAdapterWrapper;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterFunctions;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindablePropertyAdapterImpl;
import org.kie.workbench.common.stunner.core.i18n.StunnerTranslationService;

@Generated("org.kie.workbench.common.stunner.core.processors.property.BindablePropertyAdapterGenerator")
@ApplicationScoped
public class CaseManagementDefinitionSetPropertyAdapterImpl extends PropertyAdapterWrapper<Object, Object, BindablePropertyAdapter<Object, Object>> {

    @Inject
    public CaseManagementDefinitionSetPropertyAdapterImpl(StunnerTranslationService translationService,
                            BindableAdapterFunctions functions) {
        super(BindablePropertyAdapterImpl.create(translationService, functions, new HashMap<>(6)));
    }

    @PostConstruct
    public void init() {
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.variables.ProcessVariables.class, "value");
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.diagram.ProcessInstanceDescription.class, "value");
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.task.AdHocActivationCondition.class, "value");
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.diagram.Version.class, "value");
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.task.AdHocCompletionCondition.class, "value");
            adapter.addBinding(org.kie.workbench.common.stunner.cm.definition.property.diagram.Package.class, "value");
    }

}
