/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.marshall.json.oryx;

import java.util.Map;
import java.util.Set;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.oryx.OryxIdMappings;
import org.kie.workbench.common.stunner.cm.backend.marshall.json.oryx.CaseManagementOryxIdMappings;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.definition.ReusableSubprocess;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.mockito.Mock;

public class CaseManagementOryxIdMappingsTest {
    @Mock
    private DefinitionManager definitionManager;
    private OryxIdMappings oryxIdMappings;

    @Before
    public void setup() {
        this.oryxIdMappings = new CaseManagementOryxIdMappings(this.definitionManager);
    }

    @Test
    public void checkSkippedProperties() {
        Map skippedProperties = this.oryxIdMappings.getSkippedProperties();
        Set cmSkippedProperties = (Set)skippedProperties.get(CaseManagementDiagram.class);
        Assert.assertNotNull((Object)cmSkippedProperties);
    }

    @Test
    public void checkGetDefinitionMappingsForDiagram() {
        this.assertDefinitionMappings(CaseManagementDiagram.class);
    }

    @Test
    public void checkGetDefinitionMappingsForReusableSubprocess() {
        this.assertDefinitionMappings(ReusableSubprocess.class);
    }

    private void assertDefinitionMappings(Class cmClass) {
        Map definitionMappings = this.oryxIdMappings.getDefinitionMappings();
        Map cmDefinitionMappings = (Map)definitionMappings.get(cmClass);
        Assert.assertNotNull((Object)cmDefinitionMappings);
    }
}

