/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend;

import java.util.Collections;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ExpectedException;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.Bpmn2Marshaller;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.builder.GraphObjectBuilderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.oryx.OryxManager;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.backend.CaseManagementDiagramMarshaller;
import org.kie.workbench.common.stunner.cm.backend.marshall.json.CaseManagementMarshaller;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseManagementDiagramMarshallerTest {
    @Mock
    private XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller;
    @Mock
    private GraphObjectBuilderFactory graphBuilderFactory;
    @Mock
    private DefinitionManager definitionManager;
    @Mock
    private GraphIndexBuilder<?> indexBuilder;
    @Mock
    private OryxManager oryxManager;
    @Mock
    private FactoryManager factoryManager;
    @Mock
    private GraphCommandManager graphCommandManager;
    @Mock
    private GraphCommandFactory commandFactory;
    @Mock
    private RuleManager rulesManager;
    private CaseManagementDiagramMarshaller marshaller;
    @Rule
    public ExpectedException exceptionRule = ExpectedException.none();

    @Before
    public void setup() {
        this.marshaller = new CaseManagementDiagramMarshaller(this.diagramMetadataMarshaller, this.graphBuilderFactory, this.definitionManager, this.indexBuilder, this.oryxManager, this.factoryManager, null, this.rulesManager, this.graphCommandManager, this.commandFactory);
    }

    @Test
    public void getDiagramDefinitionSetClass() {
        Assert.assertEquals(CaseManagementDefinitionSet.class, (Object)this.marshaller.getDiagramDefinitionSetClass());
    }

    @Test
    public void testUpdateTitle() throws Exception {
        String name = "mockName";
        Diagram mockDiagram = this.mockDiagram("mockName", null);
        MetadataImpl metadata = new MetadataImpl();
        this.marshaller.updateTitle((Metadata)metadata, mockDiagram.getGraph());
        Assert.assertEquals((Object)metadata.getTitle(), (Object)"mockName");
    }

    @Test
    public void testMarshall_validateName() throws Exception {
        Diagram mockDiagram = this.mockDiagram(null, "mockId");
        this.exceptionRule.expect(RuntimeException.class);
        this.marshaller.marshall(mockDiagram);
    }

    @Test
    public void testMarshall_validateId() throws Exception {
        Diagram mockDiagram = this.mockDiagram("mockName", null);
        this.exceptionRule.expect(RuntimeException.class);
        this.marshaller.marshall(mockDiagram);
    }

    private Diagram mockDiagram(String name, String id) {
        DiagramSet diagramSet = (DiagramSet)Mockito.mock(DiagramSet.class);
        Mockito.when((Object)diagramSet.getName()).thenReturn((Object)new Name(name));
        Mockito.when((Object)diagramSet.getId()).thenReturn((Object)new Id(id));
        CaseManagementDiagram caseManagementDiagram = new CaseManagementDiagram();
        caseManagementDiagram.setDiagramSet(diagramSet);
        Definition definition = (Definition)Mockito.mock(Definition.class);
        Mockito.when((Object)definition.getDefinition()).thenReturn((Object)caseManagementDiagram);
        Node node = (Node)Mockito.mock(Node.class);
        Mockito.when((Object)node.getContent()).thenReturn((Object)definition);
        Graph mockGraph = (Graph)Mockito.mock(Graph.class);
        Mockito.when((Object)mockGraph.nodes()).thenReturn(Collections.singletonList(node));
        Diagram mockDiagram = (Diagram)Mockito.mock(Diagram.class);
        Mockito.when((Object)mockDiagram.getGraph()).thenReturn((Object)mockGraph);
        return mockDiagram;
    }

    @Test
    public void testCreateBpmn2Marshaller() throws Exception {
        Bpmn2Marshaller bpmn2Marshaller = this.marshaller.createBpmn2Marshaller((DefinitionManager)Mockito.mock(DefinitionManager.class), (OryxManager)Mockito.mock(OryxManager.class));
        Assert.assertTrue((boolean)(bpmn2Marshaller instanceof CaseManagementMarshaller));
    }
}

