/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.marshall.json;

import java.util.ArrayList;
import java.util.stream.IntStream;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.ItemDefinition;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.oryx.OryxManager;
import org.kie.workbench.common.stunner.cm.backend.marshall.json.CaseManagementMarshaller;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.mockito.Mockito;

public class CaseManagementMarshallerTest {
    private CaseManagementMarshaller marshaller;

    @Before
    public void setUp() throws Exception {
        this.marshaller = new CaseManagementMarshaller((DefinitionManager)Mockito.mock(DefinitionManager.class), (OryxManager)Mockito.mock(OryxManager.class));
    }

    @Test
    public void testRevisitSubProcessItemDefs() throws Exception {
        ArrayList rootElementList = new ArrayList(0);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)definitions.getRootElements()).thenReturn(rootElementList);
        this.marshaller.revisitSubProcessItemDefs(definitions);
        Assert.assertTrue((boolean)rootElementList.isEmpty());
    }

    @Test
    public void testAddSubprocessItemDefs() throws Exception {
        ArrayList<Object> itemDefinitionList = new ArrayList<Object>(3);
        itemDefinitionList.add(Mockito.mock(ItemDefinition.class));
        itemDefinitionList.add(Mockito.mock(ItemDefinition.class));
        itemDefinitionList.add(Mockito.mock(ItemDefinition.class));
        itemDefinitionList.stream().forEach(i -> this.marshaller.addSubprocessItemDefs(i));
        ArrayList rootElementList = new ArrayList(3);
        Definitions definitions = (Definitions)Mockito.mock(Definitions.class);
        Mockito.when((Object)definitions.getRootElements()).thenReturn(rootElementList);
        this.marshaller.revisitSubProcessItemDefs(definitions);
        Assert.assertTrue((boolean)IntStream.range(0, itemDefinitionList.size()).allMatch(i -> ((ItemDefinition)itemDefinitionList.get(i)).equals(rootElementList.get(i))));
        rootElementList.clear();
        this.marshaller.revisitSubProcessItemDefs(definitions);
        Assert.assertTrue((boolean)rootElementList.isEmpty());
    }
}

