/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.backend.BaseDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.DefinitionsBuildingContext;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.properties.PropertyWriterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.workitem.service.WorkItemDefinitionBackendService;
import org.kie.workbench.common.stunner.bpmn.definition.EndNoneEvent;
import org.kie.workbench.common.stunner.bpmn.definition.SequenceFlow;
import org.kie.workbench.common.stunner.bpmn.definition.StartNoneEvent;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.backend.converters.fromstunner.CaseManagementConverterFactory;
import org.kie.workbench.common.stunner.cm.backend.converters.fromstunner.properties.CaseManagementPropertyWriterFactory;
import org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.qualifiers.CaseManagementEditor;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.view.Connection;
import org.kie.workbench.common.stunner.core.graph.content.view.MagnetConnection;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewConnector;
import org.kie.workbench.common.stunner.core.graph.impl.EdgeImpl;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.util.UUID;

@Dependent
@CaseManagementEditor
public class CaseManagementDirectDiagramMarshaller
extends BaseDirectDiagramMarshaller {
    private static final double GAP = 50.0;
    private static final double STAGE_GAP = 25.0;
    private static final double ORIGIN_X = 50.0;
    private static final double ORIGIN_Y = 50.0;
    private static final double EVENT_WIDTH = 55.0;
    private static final double EVENT_HEIGHT = 55.0;

    @Inject
    public CaseManagementDirectDiagramMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, DefinitionManager definitionManager, RuleManager ruleManager, WorkItemDefinitionBackendService workItemDefinitionService, FactoryManager factoryManager, GraphCommandFactory commandFactory, GraphCommandManager commandManager) {
        super(diagramMetadataMarshaller, definitionManager, ruleManager, workItemDefinitionService, factoryManager, commandFactory, commandManager);
    }

    public String marshall(Diagram<Graph, Metadata> diagram) throws IOException {
        this.preMarshallProcess(diagram);
        return super.marshall(diagram);
    }

    private void preMarshallProcess(Diagram<Graph, Metadata> diagram) {
        Iterable nodes = diagram.getGraph().nodes();
        StreamSupport.stream(nodes.spliterator(), false).filter(node -> CaseManagementDiagram.class.isInstance(((View)node.getContent()).getDefinition())).findAny().ifPresent(root -> {
            Node rootNode = root;
            double stageWidth = this.adjustNodeBounds((Node<View, Edge<View, Node<View, Edge<View, Node<View, Edge>>>>>)rootNode);
            Node startNoneEvent = this.typedFactoryManager.newNode(UUID.uuid(), StartNoneEvent.class);
            ((View)startNoneEvent.getContent()).setBounds(Bounds.create((double)50.0, (double)50.0, (double)105.0, (double)105.0));
            diagram.getGraph().addNode(startNoneEvent);
            this.createChild(UUID.uuid(), rootNode, startNoneEvent, 0);
            double endNodeEventX = 155.0 + stageWidth;
            Node endNoneEvent = this.typedFactoryManager.newNode(UUID.uuid(), EndNoneEvent.class);
            ((View)endNoneEvent.getContent()).setBounds(Bounds.create((double)endNodeEventX, (double)50.0, (double)(endNodeEventX + 55.0), (double)105.0));
            diagram.getGraph().addNode(endNoneEvent);
            this.createChild(UUID.uuid(), rootNode, endNoneEvent, rootNode.getOutEdges().size());
            this.buildChildEdge(rootNode);
        });
    }

    private void buildChildEdge(Node parentNode) {
        List nodes = parentNode.getOutEdges().stream().map(e -> ((Edge)e).getTargetNode()).collect(Collectors.toList());
        int n = nodes.size() - 1;
        for (int i = 0; i < n; ++i) {
            this.createEdge(UUID.uuid(), (Node)nodes.get(i), (Node)nodes.get(i + 1));
        }
    }

    private void createEdge(String uuid, Node sourceNode, Node targetNode) {
        Edge edge = this.typedFactoryManager.newEdge(uuid, SequenceFlow.class);
        edge.setSourceNode(sourceNode);
        edge.setTargetNode(targetNode);
        sourceNode.getOutEdges().add(edge);
        targetNode.getInEdges().add(edge);
        ViewConnector content = (ViewConnector)edge.getContent();
        content.setSourceConnection((Connection)MagnetConnection.Builder.atCenter((Element)sourceNode));
        content.setTargetConnection((Connection)MagnetConnection.Builder.atCenter((Element)targetNode));
    }

    private void createChild(String uuid, Node parent, Node child, int parentIndex) {
        EdgeImpl edge = new EdgeImpl(uuid);
        edge.setContent((Object)new Child());
        edge.setSourceNode(parent);
        edge.setTargetNode(child);
        parent.getOutEdges().add(parentIndex, edge);
        child.getInEdges().add(edge);
    }

    private double adjustNodeBounds(Node<View, Edge<View, Node<View, Edge<View, Node<View, Edge>>>>> rootNode) {
        List stages = rootNode.getOutEdges().stream().map(Edge::getTargetNode).filter(n -> AdHocSubprocess.class.isInstance(((View)n.getContent()).getDefinition())).collect(Collectors.toList());
        if (stages.isEmpty()) {
            return 0.0;
        }
        double stageWidth = stages.stream().mapToDouble(stage -> stage.getOutEdges().stream().mapToDouble(edge -> ((View)edge.getTargetNode().getContent()).getBounds().getWidth() + 50.0).max().orElse(((View)stage.getContent()).getBounds().getWidth())).max().getAsDouble();
        double stageHeight = stages.stream().mapToDouble(stage -> {
            double sHeight;
            double cHeight = stage.getOutEdges().stream().mapToDouble(edge -> ((View)edge.getTargetNode().getContent()).getBounds().getHeight() + 25.0).sum() + 25.0;
            return cHeight > (sHeight = ((View)stage.getContent()).getBounds().getHeight()) ? cHeight : sHeight;
        }).max().getAsDouble();
        List stageXs = DoubleStream.iterate(155.0, x -> x + stageWidth + 50.0).limit(stages.size()).boxed().collect(Collectors.toList());
        IntStream.range(0, stages.size()).forEach(index -> {
            Node node = (Node)stages.get(index);
            double x = (Double)stageXs.get(index);
            ((View)node.getContent()).setBounds(Bounds.create((double)x, (double)50.0, (double)(x + stageWidth), (double)(50.0 + stageHeight)));
            ArrayList<Double> childYs = new ArrayList<Double>(node.getOutEdges().size());
            double heightSum = 25.0;
            for (Edge edge : node.getOutEdges()) {
                childYs.add(heightSum);
                heightSum = heightSum + ((View)edge.getTargetNode().getContent()).getBounds().getHeight() + 25.0;
            }
            IntStream.range(0, node.getOutEdges().size()).forEach(i -> {
                Node childNode = ((Edge)node.getOutEdges().get(i)).getTargetNode();
                double cx = (stageWidth - ((View)childNode.getContent()).getBounds().getWidth()) / 2.0;
                double cy = (Double)childYs.get(i);
                ((View)childNode.getContent()).setBounds(Bounds.create((double)cx, (double)cy, (double)(cx + ((View)childNode.getContent()).getBounds().getWidth()), (double)(cy + ((View)childNode.getContent()).getBounds().getHeight())));
            });
        });
        return (double)stages.size() * (stageWidth + 50.0);
    }

    public Graph<DefinitionSet, Node> unmarshall(Metadata metadata, InputStream inputStream) throws IOException {
        Graph graph = super.unmarshall(metadata, inputStream);
        this.postUnmarshallProcess((Graph<DefinitionSet, Node>)graph);
        return graph;
    }

    private void postUnmarshallProcess(Graph<DefinitionSet, Node> graph) {
        List nodes = StreamSupport.stream(graph.nodes().spliterator(), false).map(n -> n).collect(Collectors.toList());
        nodes.stream().filter(node -> CaseManagementDiagram.class.isInstance(((View)node.getContent()).getDefinition())).findAny().ifPresent(root -> {
            Node endNode;
            this.deleteChildEdge((Node)root);
            Node startNode = ((Edge)root.getOutEdges().get(0)).getTargetNode();
            if (StartNoneEvent.class.isInstance(((View)startNode.getContent()).getDefinition())) {
                this.deleteChild((Node)root, startNode);
                graph.removeNode(startNode.getUUID());
            }
            if (EndNoneEvent.class.isInstance(((View)(endNode = ((Edge)root.getOutEdges().get(root.getOutEdges().size() - 1)).getTargetNode()).getContent()).getDefinition())) {
                this.deleteChild((Node)root, endNode);
                graph.removeNode(endNode.getUUID());
            }
            Stream<Node> stageStream = root.getOutEdges().stream().map(Edge::getTargetNode);
            stageStream.filter(n -> AdHocSubprocess.class.isInstance(((View)n.getContent()).getDefinition())).forEach(n -> Collections.sort(n.getOutEdges(), (e1, e2) -> {
                double y1 = ((View)e1.getTargetNode().getContent()).getBounds().getY();
                double y2 = ((View)e2.getTargetNode().getContent()).getBounds().getY();
                return Double.compare(y1, y2);
            }));
        });
    }

    private void deleteChildEdge(Node parentNode) {
        LinkedList childNodes = new LinkedList();
        parentNode.getOutEdges().stream().map(e -> ((Edge)e).getTargetNode()).filter(n -> ((Node)n).getInEdges().size() == 1).findAny().ifPresent(nd -> {
            Node node = (Node)nd;
            do {
                childNodes.add(node);
            } while ((node = this.deleteEdge(node)) != null);
            List<Edge> childEdges = childNodes.stream().map(n -> (Edge)parentNode.getOutEdges().stream().filter(e -> n.equals(((Edge)e).getTargetNode())).findAny().get()).collect(Collectors.toList());
            parentNode.getOutEdges().clear();
            childEdges.forEach(e -> parentNode.getOutEdges().add(e));
        });
    }

    private void deleteChild(Node parent, Node child) {
        parent.getOutEdges().stream().filter(edge -> child.equals(((Edge)edge).getTargetNode())).findAny().ifPresent(edge -> {
            parent.getOutEdges().remove(edge);
            child.getInEdges().remove(edge);
        });
    }

    private Node deleteEdge(Node sourceNode) {
        Edge targetEdge = sourceNode.getOutEdges().stream().filter(edge -> ((Edge)edge).getContent() instanceof ViewConnector && ((ViewConnector)((Edge)edge).getContent()).getDefinition() instanceof SequenceFlow).findAny().orElse(null);
        if (targetEdge != null) {
            Node targetNode = targetEdge.getTargetNode();
            sourceNode.getOutEdges().remove(targetEdge);
            targetNode.getInEdges().remove(targetEdge);
            return targetNode;
        }
        return null;
    }

    protected CaseManagementConverterFactory createFromStunnerConverterFactory(Graph graph, PropertyWriterFactory propertyWriterFactory) {
        return new CaseManagementConverterFactory(new DefinitionsBuildingContext(graph, CaseManagementDiagram.class), propertyWriterFactory);
    }

    protected org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory createToStunnerConverterFactory(DefinitionResolver definitionResolver, TypedFactoryManager typedFactoryManager) {
        return new org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory(definitionResolver, typedFactoryManager);
    }

    protected CaseManagementPropertyWriterFactory createPropertyWriterFactory() {
        return new CaseManagementPropertyWriterFactory();
    }

    protected Class<CaseManagementDefinitionSet> getDefinitionSetClass() {
        return CaseManagementDefinitionSet.class;
    }
}

