/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend;

import java.io.InputStream;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.bpmn.backend.BaseDiagramMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.Bpmn2Marshaller;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.Bpmn2UnMarshaller;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.builder.GraphObjectBuilderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.marshall.json.oryx.OryxManager;
import org.kie.workbench.common.stunner.bpmn.definition.BPMNDiagram;
import org.kie.workbench.common.stunner.bpmn.definition.property.diagram.Id;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.Name;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.backend.marshall.json.CaseManagementMarshaller;
import org.kie.workbench.common.stunner.cm.backend.marshall.json.CaseManagementUnMarshaller;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.cm.qualifiers.CaseManagementEditor;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.command.CommandManager;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandExecutionContext;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.registry.impl.DefinitionsCacheRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleViolation;

@Dependent
@CaseManagementEditor
public class CaseManagementDiagramMarshaller
extends BaseDiagramMarshaller<CaseManagementDiagram> {
    @Inject
    public CaseManagementDiagramMarshaller(XMLEncoderDiagramMetadataMarshaller diagramMetadataMarshaller, @CaseManagementEditor GraphObjectBuilderFactory graphBuilderFactory, DefinitionManager definitionManager, GraphIndexBuilder<?> indexBuilder, @CaseManagementEditor OryxManager oryxManager, FactoryManager factoryManager, DefinitionsCacheRegistry definitionsCacheRegistry, RuleManager rulesManager, GraphCommandManager graphCommandManager, GraphCommandFactory commandFactory) {
        super(diagramMetadataMarshaller, graphBuilderFactory, definitionManager, indexBuilder, oryxManager, factoryManager, definitionsCacheRegistry, rulesManager, graphCommandManager, commandFactory);
    }

    protected String getPreProcessingData(Metadata metadata) {
        return null;
    }

    public Class<?> getDiagramDefinitionSetClass() {
        return CaseManagementDefinitionSet.class;
    }

    public Class<? extends BPMNDiagram> getDiagramDefinitionClass() {
        return CaseManagementDiagram.class;
    }

    public Graph unmarshall(Metadata metadata, InputStream inputStream) {
        Graph result = super.unmarshall(metadata, inputStream);
        this.updateTitle(metadata, result);
        return result;
    }

    public String marshall(Diagram diagram) {
        if (this.validateDiagram(diagram)) {
            return super.marshall(diagram);
        }
        throw new RuntimeException("Invalid definition for Case Modeler diagram.");
    }

    private boolean validateDiagram(Diagram diagram) {
        DiagramSet diagramSet;
        CaseManagementDiagram definition;
        Node node = GraphUtils.getFirstNode((Graph)diagram.getGraph(), CaseManagementDiagram.class);
        if (node != null && node.getContent() != null && (definition = (CaseManagementDiagram)((Definition)node.getContent()).getDefinition()) != null && (diagramSet = definition.getDiagramSet()) != null) {
            Name name = diagramSet.getName();
            Id id = diagramSet.getId();
            return name != null && id != null && name.getValue() != null && id.getValue() != null && name.getValue().trim().length() > 0 && id.getValue().trim().length() > 0;
        }
        return false;
    }

    protected Bpmn2Marshaller createBpmn2Marshaller(DefinitionManager definitionManager, OryxManager oryxManager) {
        return new CaseManagementMarshaller(definitionManager, oryxManager);
    }

    protected Bpmn2UnMarshaller createBpmn2UnMarshaller(GraphObjectBuilderFactory elementBuilderFactory, DefinitionManager definitionManager, FactoryManager factoryManager, DefinitionsCacheRegistry definitionsCacheRegistry, RuleManager rulesManager, OryxManager oryxManager, GraphCommandManager commandManager, GraphCommandFactory commandFactory, GraphIndexBuilder<?> indexBuilder, Class<?> diagramDefinitionSetClass, Class<? extends BPMNDiagram> diagramDefinitionClass) {
        return new CaseManagementUnMarshaller(elementBuilderFactory, definitionManager, factoryManager, definitionsCacheRegistry, rulesManager, oryxManager, (CommandManager<GraphCommandExecutionContext, RuleViolation>)commandManager, commandFactory, indexBuilder, diagramDefinitionSetClass, diagramDefinitionClass);
    }
}

