/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import org.kie.workbench.common.stunner.bpmn.workitem.ServiceTaskFactory;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.backend.BackendFactoryManager;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingModelFactory;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendDefinitionAdapter;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.DiagramImpl;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.diagram.MetadataImpl;
import org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory;
import org.kie.workbench.common.stunner.core.factory.graph.GraphFactory;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;

public class MockApplicationFactoryManager
extends BackendFactoryManager {
    static final String CM_DEF_SET_ID = BindableAdapterUtils.getDefinitionSetId(CaseManagementDefinitionSet.class);
    private final GraphFactory graphFactory;
    private final StunnerTestingModelFactory testScopeModelFactory;
    private final EdgeFactory<Object> connectionEdgeFactory;
    private final NodeFactory<Object> viewNodeFactory;
    private final ServiceTaskFactory serviceTaskFactory;

    public MockApplicationFactoryManager(DefinitionManager definitionManager, GraphFactory graphFactory, StunnerTestingModelFactory testScopeModelFactory, EdgeFactory<Object> connectionEdgeFactory, NodeFactory<Object> viewNodeFactory) {
        super(definitionManager);
        this.graphFactory = graphFactory;
        this.testScopeModelFactory = testScopeModelFactory;
        this.connectionEdgeFactory = connectionEdgeFactory;
        this.viewNodeFactory = viewNodeFactory;
        this.serviceTaskFactory = new ServiceTaskFactory(() -> null);
    }

    public <T> T newDefinition(String id) {
        return (T)this.testScopeModelFactory.build(id);
    }

    public Element<?> newElement(String uuid, String id) {
        Object model;
        if (CM_DEF_SET_ID.equals(id)) {
            Graph graph = (Graph)this.graphFactory.build(uuid, (Object)CM_DEF_SET_ID);
            return graph;
        }
        Object object = model = this.testScopeModelFactory.accepts(id) ? this.testScopeModelFactory.build(id) : this.serviceTaskFactory.build(id);
        if (null != model) {
            Class element = BackendDefinitionAdapter.getGraphFactory(model.getClass());
            if (element.isAssignableFrom(NodeFactory.class)) {
                return this.viewNodeFactory.build(uuid, model);
            }
            if (element.isAssignableFrom(EdgeFactory.class)) {
                return this.connectionEdgeFactory.build(uuid, model);
            }
        }
        return null;
    }

    public <M extends Metadata, D extends Diagram> D newDiagram(String uuid, String defSetId, M metadata) {
        Graph graph = (Graph)this.newElement(uuid, defSetId);
        DiagramImpl result = new DiagramImpl(uuid, (Metadata)new MetadataImpl.MetadataImplBuilder(defSetId).build());
        result.setGraph(graph);
        return (D)result;
    }

    private Object invokeEmptyConstructor(Class<?> type, String id) {
        try {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalArgumentException("No constructor for type " + id, e);
        }
    }
}

