/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes;

import java.util.Collections;
import org.eclipse.bpmn2.AdHocOrdering;
import org.eclipse.bpmn2.AdHocSubProcess;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.FormalExpression;
import org.eclipse.bpmn2.LoopCharacteristics;
import org.eclipse.bpmn2.MultiInstanceLoopCharacteristics;
import org.eclipse.bpmn2.SubProcess;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.Result;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BpmnNode;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.AdHocSubProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.EmbeddedSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.EventSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.MultipleInstanceSubprocess;
import org.kie.workbench.common.stunner.bpmn.definition.property.general.SLADueDate;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes.CaseManagementSubProcessConverter;
import org.kie.workbench.common.stunner.cm.definition.AdHocSubprocess;
import org.kie.workbench.common.stunner.cm.definition.property.task.AdHocSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CaseManagementSubProcessConverterTest {
    private static final String SLA_DUE_DATE = "12/25/1983";
    private DefinitionResolver definitionResolver;
    private CaseManagementSubProcessConverter tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        NodeImpl adHocNode = new NodeImpl("");
        ViewImpl adHocContent = new ViewImpl((Object)new AdHocSubprocess(), Bounds.create());
        adHocNode.setContent((Object)adHocContent);
        NodeImpl multipleInstanceNode = new NodeImpl("");
        ViewImpl miContent = new ViewImpl((Object)new MultipleInstanceSubprocess(), Bounds.create());
        multipleInstanceNode.setContent((Object)miContent);
        NodeImpl embeddedNode = new NodeImpl("");
        ViewImpl embeddedContent = new ViewImpl((Object)new EmbeddedSubprocess(), Bounds.create());
        embeddedNode.setContent((Object)embeddedContent);
        NodeImpl eventNode = new NodeImpl("");
        ViewImpl eventSubprocess = new ViewImpl((Object)new EventSubprocess(), Bounds.create());
        eventNode.setContent((Object)eventSubprocess);
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(AdHocSubprocess.class)))).thenReturn((Object)adHocNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(MultipleInstanceSubprocess.class)))).thenReturn((Object)multipleInstanceNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(EmbeddedSubprocess.class)))).thenReturn((Object)embeddedNode);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(EventSubprocess.class)))).thenReturn((Object)eventNode);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.tested = new CaseManagementSubProcessConverter(typedFactoryManager, new PropertyReaderFactory(this.definitionResolver), this.definitionResolver, (BaseConverterFactory)new CaseManagementConverterFactory(this.definitionResolver, typedFactoryManager));
    }

    @Test
    public void testCreateNode() {
        Assert.assertTrue((boolean)AdHocSubprocess.class.isInstance(((View)this.tested.createNode("id").getContent()).getDefinition()));
    }

    @Test
    public void testCreateProcessData() {
        Assert.assertTrue((boolean)ProcessData.class.isInstance(this.tested.createProcessData("id")));
    }

    @Test
    public void testCreateAdHocSubprocessTaskExecutionSet() {
        AdHocSubProcess adHocSubProcess = (AdHocSubProcess)Mockito.mock(AdHocSubProcess.class);
        Mockito.when((Object)adHocSubProcess.getCompletionCondition()).thenReturn(Mockito.mock(FormalExpression.class));
        Mockito.when((Object)adHocSubProcess.getOrdering()).thenReturn((Object)AdHocOrdering.SEQUENTIAL);
        Assert.assertTrue((boolean)AdHocSubprocessTaskExecutionSet.class.isInstance(this.tested.createAdHocSubprocessTaskExecutionSet(new AdHocSubProcessPropertyReader(adHocSubProcess, this.definitionResolver.getDiagram(), this.definitionResolver))));
    }

    @Test
    public void testConvertAdHocSubprocessNode_SlaDueDate() {
        AdHocSubProcess subProcess = Factories.bpmn2.createAdHocSubProcess();
        subProcess.setTriggeredByEvent(Boolean.TRUE.booleanValue());
        CustomElement.async.setValue((BaseElement)subProcess, (Object)Boolean.TRUE);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)SLA_DUE_DATE);
        Result result = this.tested.convertSubProcess((SubProcess)subProcess);
        BpmnNode node = (BpmnNode)result.value();
        AdHocSubprocess adHocSubprocess = (AdHocSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)adHocSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)adHocSubprocess.getExecutionSet());
    }

    @Test
    public void testConvertMultInstanceSubprocessNode_SlaDueDate() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        MultiInstanceLoopCharacteristics loopCharacteristics = Factories.bpmn2.createMultiInstanceLoopCharacteristics();
        subProcess.setLoopCharacteristics((LoopCharacteristics)loopCharacteristics);
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)SLA_DUE_DATE);
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        MultipleInstanceSubprocess miSubProcces = (MultipleInstanceSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)miSubProcces);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)miSubProcces.getExecutionSet());
    }

    @Test
    public void testConvertEmbeddedSubprocessNode_SlaDueDate() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)SLA_DUE_DATE);
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EmbeddedSubprocess embeddedSubProcces = (EmbeddedSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)embeddedSubProcces);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)embeddedSubProcces.getExecutionSet());
    }

    @Test
    public void testConvertEventSubprocessNode_SlaDueDate() {
        SubProcess subProcess = Factories.bpmn2.createSubProcess();
        subProcess.setTriggeredByEvent(Boolean.TRUE.booleanValue());
        CustomElement.slaDueDate.setValue((BaseElement)subProcess, (Object)SLA_DUE_DATE);
        Result result = this.tested.convertSubProcess(subProcess);
        BpmnNode node = (BpmnNode)result.value();
        EventSubprocess eventSubprocess = (EventSubprocess)((View)node.value().getContent()).getDefinition();
        Assert.assertNotNull((Object)eventSubprocess);
        this.assertBaseSubprocessExecutionSet((BaseSubprocessTaskExecutionSet)eventSubprocess.getExecutionSet());
    }

    private void assertBaseSubprocessExecutionSet(BaseSubprocessTaskExecutionSet executionSet) {
        Assert.assertNotNull((Object)executionSet);
        SLADueDate slaDueDate = executionSet.getSlaDueDate();
        Assert.assertNotNull((Object)slaDueDate);
        Assert.assertTrue((boolean)slaDueDate.getValue().contains(SLA_DUE_DATE));
    }
}

