/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.forms.gen;

import org.eclipse.bpmn2.Definitions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.backend.CaseManagementBackendService;
import org.kie.workbench.common.stunner.cm.backend.CaseManagementDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.cm.backend.forms.gen.CaseManagementFormGenerationModelProvider;
import org.kie.workbench.common.stunner.cm.backend.forms.gen.util.CaseManagementFormGenerationModelProviderHelper;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.diagram.Metadata;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseManagementFormGenerationModelProviderTest {
    private static final String ID = "id";
    @Mock
    private CaseManagementDirectDiagramMarshaller cmDirectDiagramMarshaller;
    @Mock
    private CaseManagementBackendService cmBackendService;
    @Mock
    private DefinitionUtils definitionUtils;
    @Mock
    private Diagram diagram;
    @Mock
    private Definitions definitions;
    @Mock
    private Metadata metadata;
    private CaseManagementFormGenerationModelProvider tested;
    private CaseManagementFormGenerationModelProviderHelper formGenerationModelProviderHelper;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.diagram.getMetadata()).thenReturn((Object)this.metadata);
        Mockito.when((Object)this.metadata.getDefinitionSetId()).thenReturn((Object)ID);
        Mockito.when((Object)this.definitionUtils.getDefinitionSetId((Class)Matchers.eq(CaseManagementDefinitionSet.class))).thenReturn((Object)ID);
        this.formGenerationModelProviderHelper = new CaseManagementFormGenerationModelProviderHelper(this.cmBackendService);
        this.tested = new CaseManagementFormGenerationModelProvider(this.definitionUtils, this.formGenerationModelProviderHelper);
        this.tested.init();
        ((DefinitionUtils)Mockito.verify((Object)this.definitionUtils)).getDefinitionSetId((Class)Matchers.eq(CaseManagementDefinitionSet.class));
    }

    @Test
    public void testAccepts() throws Exception {
        Assert.assertTrue((boolean)this.tested.accepts(this.diagram));
    }

    @Test
    public void testGenerateForCaseManagementDirectDiagramMarshaller() throws Exception {
        Mockito.when((Object)this.cmDirectDiagramMarshaller.marshallToBpmn2Definitions(this.diagram)).thenReturn((Object)this.definitions);
        Mockito.when((Object)this.cmBackendService.getDiagramMarshaller()).thenReturn((Object)this.cmDirectDiagramMarshaller);
        Definitions result = this.tested.generate(this.diagram);
        ((CaseManagementDirectDiagramMarshaller)Mockito.verify((Object)this.cmDirectDiagramMarshaller, (VerificationMode)Mockito.times((int)1))).marshallToBpmn2Definitions((Diagram)Matchers.eq((Object)this.diagram));
        Assert.assertEquals((Object)result, (Object)this.definitions);
    }
}

