/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.query;

import java.util.HashSet;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueIndexTerm;
import org.kie.workbench.common.services.refactoring.model.index.terms.valueterms.ValueResourceIndexTerm;
import org.kie.workbench.common.services.refactoring.service.ResourceType;
import org.kie.workbench.common.stunner.cm.backend.query.FindCaseManagementIdsQuery;

public class FindCaseManagementIdsQueryTest {
    private FindCaseManagementIdsQuery tested = new FindCaseManagementIdsQuery();

    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testGetProcessIdResourceType() throws Exception {
        Assert.assertEquals((Object)this.tested.getProcessIdResourceType(), (Object)ResourceType.BPMN_CM);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateTerms_noQueryTerms() {
        HashSet queryTerms = new HashSet();
        this.tested.validateTerms(queryTerms);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testValidateTerms_inValidQueryTerms() {
        HashSet<ValueResourceIndexTerm> queryTerms = new HashSet<ValueResourceIndexTerm>();
        queryTerms.add(new ValueResourceIndexTerm("not-bpmn2-resources", ResourceType.JAVA));
        this.tested.validateTerms(queryTerms);
    }

    @Test
    public void testValidateTerms() {
        HashSet<ValueResourceIndexTerm> queryTerms = new HashSet<ValueResourceIndexTerm>();
        queryTerms.add(new ValueResourceIndexTerm("*", ResourceType.BPMN_CM, ValueIndexTerm.TermSearchType.WILDCARD));
        try {
            this.tested.validateTerms(queryTerms);
        }
        catch (IllegalArgumentException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }
}

