/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend;

import java.util.Collections;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.workitem.service.WorkItemDefinitionLookupService;
import org.kie.workbench.common.stunner.cm.CaseManagementDefinitionSet;
import org.kie.workbench.common.stunner.cm.backend.CaseManagementDirectDiagramMarshaller;
import org.kie.workbench.common.stunner.cm.backend.MockApplicationFactoryManager;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.backend.BackendFactoryManager;
import org.kie.workbench.common.stunner.core.backend.StunnerTestingModelFactory;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendDefinitionAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendDefinitionSetAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendPropertyAdapter;
import org.kie.workbench.common.stunner.core.backend.definition.adapter.reflect.BackendPropertySetAdapter;
import org.kie.workbench.common.stunner.core.backend.service.XMLEncoderDiagramMetadataMarshaller;
import org.kie.workbench.common.stunner.core.definition.adapter.AdapterManager;
import org.kie.workbench.common.stunner.core.factory.graph.EdgeFactory;
import org.kie.workbench.common.stunner.core.factory.graph.GraphFactory;
import org.kie.workbench.common.stunner.core.factory.graph.NodeFactory;
import org.kie.workbench.common.stunner.core.factory.impl.EdgeFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.GraphFactoryImpl;
import org.kie.workbench.common.stunner.core.factory.impl.NodeFactoryImpl;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManager;
import org.kie.workbench.common.stunner.core.graph.command.GraphCommandManagerImpl;
import org.kie.workbench.common.stunner.core.graph.command.impl.GraphCommandFactory;
import org.kie.workbench.common.stunner.core.registry.definition.AdapterRegistry;
import org.kie.workbench.common.stunner.core.rule.RuleEvaluationContext;
import org.kie.workbench.common.stunner.core.rule.RuleManager;
import org.kie.workbench.common.stunner.core.rule.RuleSet;
import org.kie.workbench.common.stunner.core.rule.violations.DefaultRuleViolations;
import org.kie.workbench.common.stunner.core.util.DefinitionUtils;
import org.mockito.Matchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.runners.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class CaseManagementDirectDiagramMarshallerTest {
    @Mock
    DefinitionManager definitionManager;
    @Mock
    AdapterManager adapterManager;
    @Mock
    AdapterRegistry adapterRegistry;
    @Mock
    RuleManager rulesManager;
    BackendFactoryManager applicationFactoryManager;
    private CaseManagementDirectDiagramMarshaller tested;

    @Before
    public void setUp() throws Exception {
        Mockito.when((Object)this.definitionManager.adapters()).thenReturn((Object)this.adapterManager);
        Mockito.when((Object)this.adapterManager.registry()).thenReturn((Object)this.adapterRegistry);
        Mockito.when((Object)this.rulesManager.evaluate((RuleSet)Matchers.any(RuleSet.class), (RuleEvaluationContext)Matchers.any(RuleEvaluationContext.class))).thenReturn((Object)new DefaultRuleViolations());
        DefinitionUtils definitionUtils = new DefinitionUtils(this.definitionManager, null);
        StunnerTestingModelFactory testScopeModelFactory = new StunnerTestingModelFactory((Object)new CaseManagementDefinitionSet.CaseManagementDefinitionSetBuilder().build());
        BackendDefinitionAdapter definitionAdapter = new BackendDefinitionAdapter(definitionUtils);
        BackendDefinitionSetAdapter definitionSetAdapter = new BackendDefinitionSetAdapter(definitionAdapter);
        BackendPropertySetAdapter propertySetAdapter = new BackendPropertySetAdapter();
        BackendPropertyAdapter propertyAdapter = new BackendPropertyAdapter();
        this.mockAdapterManager(definitionAdapter, definitionSetAdapter, propertySetAdapter, propertyAdapter);
        this.mockAdapterRegistry(definitionAdapter, definitionSetAdapter, propertySetAdapter, propertyAdapter);
        this.applicationFactoryManager = new MockApplicationFactoryManager(this.definitionManager, (GraphFactory)new GraphFactoryImpl(this.definitionManager), testScopeModelFactory, (EdgeFactory<Object>)new EdgeFactoryImpl(this.definitionManager), (NodeFactory<Object>)new NodeFactoryImpl(definitionUtils));
        GraphCommandManagerImpl commandManager = new GraphCommandManagerImpl(null, null, null);
        GraphCommandFactory commandFactory = new GraphCommandFactory();
        WorkItemDefinitionLookupService widService = (WorkItemDefinitionLookupService)Mockito.mock(WorkItemDefinitionLookupService.class);
        this.tested = new CaseManagementDirectDiagramMarshaller(new XMLEncoderDiagramMetadataMarshaller(), this.definitionManager, this.rulesManager, widService, (FactoryManager)this.applicationFactoryManager, commandFactory, (GraphCommandManager)commandManager);
    }

    private void mockAdapterRegistry(BackendDefinitionAdapter definitionAdapter, BackendDefinitionSetAdapter definitionSetAdapter, BackendPropertySetAdapter propertySetAdapter, BackendPropertyAdapter propertyAdapter) {
        Mockito.when((Object)this.adapterRegistry.getDefinitionSetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterRegistry.getDefinitionAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertySetAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterRegistry.getPropertyAdapter((Class)Matchers.any(Class.class))).thenReturn((Object)propertyAdapter);
    }

    private void mockAdapterManager(BackendDefinitionAdapter definitionAdapter, BackendDefinitionSetAdapter definitionSetAdapter, BackendPropertySetAdapter propertySetAdapter, BackendPropertyAdapter propertyAdapter) {
        Mockito.when((Object)this.adapterManager.forDefinitionSet()).thenReturn((Object)definitionSetAdapter);
        Mockito.when((Object)this.adapterManager.forDefinition()).thenReturn((Object)definitionAdapter);
        Mockito.when((Object)this.adapterManager.forPropertySet()).thenReturn((Object)propertySetAdapter);
        Mockito.when((Object)this.adapterManager.forProperty()).thenReturn((Object)propertyAdapter);
    }

    @Test
    public void testCreateToStunnerConverterFactory() throws Exception {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        DefinitionResolver definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        Assert.assertTrue((boolean)CaseManagementConverterFactory.class.isInstance(this.tested.createToStunnerConverterFactory(definitionResolver, typedFactoryManager)));
    }

    @Test
    public void testGetDefinitionSetClass() throws Exception {
        Assert.assertEquals((Object)this.tested.getDefinitionSetClass(), CaseManagementDefinitionSet.class);
    }
}

