/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.converters.tostunner;

import java.util.Collections;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.activities.CaseManagementCallActivityConverter;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes.CaseManagementRootProcessConverter;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes.CaseManagementSubProcessConverter;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.tasks.CaseManagementTaskConverter;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.mockito.Mockito;

public class CaseManagementConverterFactoryTest {
    private DefinitionResolver definitionResolver;
    private FactoryManager factoryManager;
    private CaseManagementConverterFactory tested;

    @Before
    public void setUp() throws Exception {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        this.factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        this.tested = new CaseManagementConverterFactory(this.definitionResolver, new TypedFactoryManager(this.factoryManager));
    }

    @Test
    public void testRootProcessConverter() throws Exception {
        Assert.assertTrue((boolean)CaseManagementRootProcessConverter.class.isInstance(this.tested.rootProcessConverter()));
    }

    @Test
    public void testSubProcessConverter() throws Exception {
        Assert.assertTrue((boolean)CaseManagementSubProcessConverter.class.isInstance(this.tested.subProcessConverter()));
    }

    @Test
    public void testCreateCallActivityConverter() throws Exception {
        Assert.assertTrue((boolean)CaseManagementCallActivityConverter.class.isInstance(this.tested.callActivityConverter()));
    }

    @Test
    public void testTaskConverter() throws Exception {
        Assert.assertTrue((boolean)CaseManagementTaskConverter.class.isInstance(this.tested.taskConverter()));
    }
}

