/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.converters.tostunner.activities;

import java.util.Collections;
import java.util.UUID;
import org.eclipse.bpmn2.BaseElement;
import org.eclipse.bpmn2.CallActivity;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.customproperties.CustomElement;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.CallActivityPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.property.task.BaseReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.activities.CaseManagementCallActivityConverter;
import org.kie.workbench.common.stunner.cm.definition.CaseReusableSubprocess;
import org.kie.workbench.common.stunner.cm.definition.ProcessReusableSubprocess;
import org.kie.workbench.common.stunner.cm.definition.property.task.CaseReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.cm.definition.property.task.ProcessReusableSubprocessTaskExecutionSet;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CaseManagementCallActivityConverterTest {
    private static final String SLA_DUE_DATE = "12/25/1983";
    private DefinitionResolver definitionResolver;
    private FactoryManager factoryManager;
    private CaseManagementCallActivityConverter tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        this.factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        this.tested = new CaseManagementCallActivityConverter(new TypedFactoryManager(this.factoryManager), new PropertyReaderFactory(this.definitionResolver));
    }

    @Test
    public void testCreateNode_case() {
        String uuid = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(uuid);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        CallActivityPropertyReader propertyReader = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        this.tested.createNode(callActivity, propertyReader);
        ((FactoryManager)Mockito.verify((Object)this.factoryManager)).newElement((String)Matchers.eq((Object)uuid), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(CaseReusableSubprocess.class)));
    }

    @Test
    public void testCreateNode_process() {
        String uuid = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(uuid);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        CallActivityPropertyReader propertyReader = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        this.tested.createNode(callActivity, propertyReader);
        ((FactoryManager)Mockito.verify((Object)this.factoryManager)).newElement((String)Matchers.eq((Object)uuid), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(ProcessReusableSubprocess.class)));
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSet_case() {
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        CustomElement.async.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        CustomElement.slaDueDate.of((BaseElement)callActivity).set((Object)SLA_DUE_DATE);
        CallActivityPropertyReader propertyReader = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        BaseReusableSubprocessTaskExecutionSet result = this.tested.createReusableSubprocessTaskExecutionSet(callActivity, propertyReader);
        Assert.assertTrue((boolean)CaseReusableSubprocessTaskExecutionSet.class.isInstance(result));
        Assert.assertTrue((boolean)result.getIsCase().getValue());
        Assert.assertTrue((boolean)result.getIsAsync().getValue());
        Assert.assertTrue((boolean)result.getSlaDueDate().getValue().contains(SLA_DUE_DATE));
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSet_process() {
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)Boolean.FALSE);
        CustomElement.async.of((BaseElement)callActivity).set((Object)Boolean.TRUE);
        CustomElement.slaDueDate.of((BaseElement)callActivity).set((Object)SLA_DUE_DATE);
        CallActivityPropertyReader propertyReader = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        BaseReusableSubprocessTaskExecutionSet result = this.tested.createReusableSubprocessTaskExecutionSet(callActivity, propertyReader);
        Assert.assertTrue((boolean)ProcessReusableSubprocessTaskExecutionSet.class.isInstance(result));
        Assert.assertFalse((boolean)result.getIsCase().getValue());
        Assert.assertTrue((boolean)result.getIsAsync().getValue());
        Assert.assertTrue((boolean)result.getSlaDueDate().getValue().contains(SLA_DUE_DATE));
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSetWhenAbortParentTrue_case() {
        this.testAbortParent(true, true);
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSetWhenAbortParentFalse_case() {
        this.testAbortParent(false, true);
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSetWhenAbortParentTrue_process() {
        this.testAbortParent(true, false);
    }

    @Test
    public void testCreateReusableSubprocessTaskExecutionSetWhenAbortParentFalse_process() {
        this.testAbortParent(false, false);
    }

    private void testAbortParent(boolean abortParent, boolean isCase) {
        String uuid = UUID.randomUUID().toString();
        CallActivity callActivity = Factories.bpmn2.createCallActivity();
        callActivity.setId(uuid);
        CustomElement.isCase.of((BaseElement)callActivity).set((Object)isCase);
        CustomElement.abortParent.of((BaseElement)callActivity).set((Object)abortParent);
        CallActivityPropertyReader propertyReader = new CallActivityPropertyReader(callActivity, this.definitionResolver.getDiagram(), this.definitionResolver);
        BaseReusableSubprocessTaskExecutionSet result = this.tested.createReusableSubprocessTaskExecutionSet(callActivity, propertyReader);
        Assert.assertEquals((Object)isCase, (Object)result.getIsCase().getValue());
        Assert.assertEquals((Object)abortParent, (Object)result.getAbortParent().getValue());
        if (isCase) {
            Assert.assertTrue((boolean)CaseReusableSubprocessTaskExecutionSet.class.isInstance(result));
        } else {
            Assert.assertTrue((boolean)ProcessReusableSubprocessTaskExecutionSet.class.isInstance(result));
        }
    }
}

