/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes;

import java.util.Collections;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.Process;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.BaseConverterFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.DefinitionsPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.ProcessPropertyReader;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.definition.property.variables.AdvancedData;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.CaseManagementConverterFactory;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.processes.CaseManagementRootProcessConverter;
import org.kie.workbench.common.stunner.cm.definition.CaseManagementDiagram;
import org.kie.workbench.common.stunner.cm.definition.property.diagram.DiagramSet;
import org.kie.workbench.common.stunner.cm.definition.property.variables.ProcessData;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CaseManagementRootProcessConverterTest {
    private DefinitionResolver definitionResolver;
    private Process process;
    private CaseManagementRootProcessConverter tested;

    @Before
    public void setUp() {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        this.process = Factories.bpmn2.createProcess();
        definitions.getRootElements().add(this.process);
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        NodeImpl node = new NodeImpl("");
        ViewImpl content = new ViewImpl((Object)new CaseManagementDiagram(), Bounds.create());
        node.setContent((Object)content);
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(CaseManagementDiagram.class)))).thenReturn((Object)node);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.tested = new CaseManagementRootProcessConverter(typedFactoryManager, new PropertyReaderFactory(this.definitionResolver), this.definitionResolver, (BaseConverterFactory)new CaseManagementConverterFactory(this.definitionResolver, typedFactoryManager));
    }

    @Test
    public void testCreateNode() {
        Assert.assertTrue((boolean)CaseManagementDiagram.class.isInstance(((View)this.tested.createNode("id").getContent()).getDefinition()));
    }

    @Test
    public void testCreateDiagramSet() {
        Assert.assertTrue((boolean)DiagramSet.class.isInstance(this.tested.createDiagramSet(this.process, new ProcessPropertyReader(this.process, this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor()), new DefinitionsPropertyReader(this.definitionResolver.getDefinitions(), this.definitionResolver.getDiagram(), this.definitionResolver.getShape(this.process.getId()), this.definitionResolver.getResolutionFactor()))));
    }

    @Test
    public void testCreateProcessData() {
        Assert.assertTrue((boolean)ProcessData.class.isInstance(this.tested.createProcessData("id")));
    }

    @Test
    public void testCreateAdvancedData() {
        Assert.assertTrue((boolean)AdvancedData.class.isInstance(this.tested.createAdvancedData("id", "test\u00dfval")));
    }
}

