/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.cm.backend.converters.tostunner.tasks;

import java.util.Collections;
import org.eclipse.bpmn2.Definitions;
import org.eclipse.bpmn2.di.BPMNDiagram;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.kie.workbench.common.stunner.bpmn.backend.converters.TypedFactoryManager;
import org.kie.workbench.common.stunner.bpmn.backend.converters.fromstunner.Factories;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.DefinitionResolver;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.PropertyReaderFactory;
import org.kie.workbench.common.stunner.bpmn.backend.converters.tostunner.properties.UserTaskPropertyReader;
import org.kie.workbench.common.stunner.cm.backend.converters.tostunner.tasks.CaseManagementTaskConverter;
import org.kie.workbench.common.stunner.cm.definition.UserTask;
import org.kie.workbench.common.stunner.cm.definition.property.task.UserTaskExecutionSet;
import org.kie.workbench.common.stunner.core.api.FactoryManager;
import org.kie.workbench.common.stunner.core.definition.adapter.binding.BindableAdapterUtils;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.content.view.ViewImpl;
import org.kie.workbench.common.stunner.core.graph.impl.NodeImpl;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class CaseManagementTaskConverterTest {
    private DefinitionResolver definitionResolver;
    private CaseManagementTaskConverter tested;

    @Before
    public void setUp() throws Exception {
        Definitions definitions = Factories.bpmn2.createDefinitions();
        definitions.getRootElements().add(Factories.bpmn2.createProcess());
        BPMNDiagram bpmnDiagram = Factories.di.createBPMNDiagram();
        bpmnDiagram.setPlane(Factories.di.createBPMNPlane());
        definitions.getDiagrams().add(bpmnDiagram);
        this.definitionResolver = new DefinitionResolver(definitions, Collections.emptyList());
        NodeImpl node = new NodeImpl("");
        ViewImpl content = new ViewImpl((Object)new UserTask(), Bounds.create());
        node.setContent((Object)content);
        FactoryManager factoryManager = (FactoryManager)Mockito.mock(FactoryManager.class);
        Mockito.when((Object)factoryManager.newElement(Matchers.anyString(), (String)Matchers.eq((Object)BindableAdapterUtils.getDefinitionId(UserTask.class)))).thenReturn((Object)node);
        TypedFactoryManager typedFactoryManager = new TypedFactoryManager(factoryManager);
        this.tested = new CaseManagementTaskConverter(typedFactoryManager, new PropertyReaderFactory(this.definitionResolver));
    }

    @Test
    public void testCreateNode() throws Exception {
        Assert.assertTrue((boolean)UserTask.class.isInstance(((View)this.tested.createNode("id").getContent()).getDefinition()));
    }

    @Test
    public void testCreateUserTaskExecutionSet() throws Exception {
        Assert.assertTrue((boolean)UserTaskExecutionSet.class.isInstance(this.tested.createUserTaskExecutionSet(new UserTaskPropertyReader(Factories.bpmn2.createUserTask(), this.definitionResolver.getDiagram(), this.definitionResolver))));
    }
}

