/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client;

import com.google.gwt.safehtml.shared.SafeUri;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.api.DefinitionManager;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.ShapeSet;
import org.kie.workbench.common.stunner.core.client.ShapeSetThumbProvider;

@ApplicationScoped
public class ShapeManagerImpl
implements ShapeManager {
    protected SyncBeanManager beanManager;
    protected DefinitionManager definitionManager;
    private final List<ShapeSet<?>> shapeSets = new LinkedList();
    private final List<ShapeSetThumbProvider> thumbProviders = new LinkedList<ShapeSetThumbProvider>();

    protected ShapeManagerImpl() {
    }

    @Inject
    public ShapeManagerImpl(SyncBeanManager beanManager, DefinitionManager definitionManager) {
        this.beanManager = beanManager;
        this.definitionManager = definitionManager;
    }

    @PostConstruct
    public void init() {
        this.initShapeSets();
        this.initThumbProviders();
    }

    private void initShapeSets() {
        this.shapeSets.clear();
        Collection beanDefs = this.beanManager.lookupBeans(ShapeSet.class);
        for (SyncBeanDef beanDef : beanDefs) {
            ShapeSet shapeSet = (ShapeSet)beanDef.getInstance();
            this.shapeSets.add(shapeSet);
        }
    }

    private void initThumbProviders() {
        this.thumbProviders.clear();
        Collection beanDefs = this.beanManager.lookupBeans(ShapeSetThumbProvider.class);
        for (SyncBeanDef beanDef : beanDefs) {
            ShapeSetThumbProvider shapeSet = (ShapeSetThumbProvider)beanDef.getInstance();
            this.thumbProviders.add(shapeSet);
        }
    }

    public Collection<ShapeSet<?>> getShapeSets() {
        return this.shapeSets;
    }

    public ShapeSet<?> getShapeSet(String id) {
        if (null != id && !this.shapeSets.isEmpty()) {
            for (ShapeSet<?> shapeSet : this.shapeSets) {
                if (!id.equals(shapeSet.getId())) continue;
                return shapeSet;
            }
        }
        return null;
    }

    public ShapeSet<?> getDefaultShapeSet(String defSetId) {
        if (null != defSetId && !this.shapeSets.isEmpty()) {
            for (ShapeSet<?> shapeSet : this.shapeSets) {
                if (!defSetId.equals(shapeSet.getDefinitionSetId())) continue;
                return shapeSet;
            }
        }
        return null;
    }

    public SafeUri getThumbnail(String definitionSetId) {
        for (ShapeSetThumbProvider thumbProvider : this.thumbProviders) {
            if (!thumbProvider.thumbFor((Object)definitionSetId)) continue;
            return thumbProvider.getThumbnailUri();
        }
        return null;
    }
}

