/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.api.platform.impl;

import com.google.gwt.logging.client.LogConfiguration;
import com.google.gwt.user.client.Window;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.client.api.platform.ClientPlatform;
import org.kie.workbench.common.stunner.core.client.api.platform.PlatformManager;

@ApplicationScoped
public class PlatformManagerImpl
implements PlatformManager {
    private static Logger LOGGER = Logger.getLogger(PlatformManagerImpl.class.getName());
    SyncBeanManager beanManager;
    private final List<ClientPlatform> supportedPlatforms = new LinkedList<ClientPlatform>();

    protected PlatformManagerImpl() {
        this(null);
    }

    @Inject
    public PlatformManagerImpl(SyncBeanManager beanManager) {
        this.beanManager = beanManager;
    }

    @PostConstruct
    public void init() {
        Collection sets = this.beanManager.lookupBeans(ClientPlatform.class);
        for (SyncBeanDef set : sets) {
            ClientPlatform platform = (ClientPlatform)set.getInstance();
            this.supportedPlatforms.add(platform);
        }
    }

    public Iterable<ClientPlatform> getSupportedPlatforms() {
        return Collections.unmodifiableCollection(this.supportedPlatforms);
    }

    public ClientPlatform getCurrentPlatform() {
        String platform = Window.Navigator.getPlatform();
        for (ClientPlatform clientPlatform : this.supportedPlatforms) {
            if (!clientPlatform.supports(platform)) continue;
            return clientPlatform;
        }
        this.log(Level.SEVERE, "No client plaform found for [" + platform + "]");
        return null;
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

