/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.api.ClientDefinitionManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementAddedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementUpdatedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasElementsClearEvent;
import org.kie.workbench.common.stunner.core.client.canvas.listener.CanvasElementListener;
import org.kie.workbench.common.stunner.core.client.canvas.listener.HasCanvasListeners;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.shape.GraphShape;
import org.kie.workbench.common.stunner.core.client.shape.Lifecycle;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.factory.ShapeFactory;
import org.kie.workbench.common.stunner.core.diagram.Diagram;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.Bounds;
import org.kie.workbench.common.stunner.core.graph.content.definition.DefinitionSet;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.BoundsImpl;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.index.GraphIndexBuilder;
import org.kie.workbench.common.stunner.core.graph.processing.index.Index;
import org.kie.workbench.common.stunner.core.graph.processing.index.MutableIndex;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.kie.workbench.common.stunner.core.rule.Rule;
import org.kie.workbench.common.stunner.core.rule.graph.GraphRulesManager;
import org.kie.workbench.common.stunner.core.rule.model.ModelRulesManager;
import org.kie.workbench.common.stunner.core.util.UUID;

public abstract class AbstractCanvasHandler<D extends Diagram, C extends AbstractCanvas>
implements CanvasHandler<D, C>,
HasCanvasListeners<CanvasElementListener> {
    private static Logger LOGGER = Logger.getLogger(AbstractCanvasHandler.class.getName());
    private final ClientDefinitionManager clientDefinitionManager;
    private final ClientFactoryService clientFactoryServices;
    private final GraphRulesManager graphRulesManager;
    private final ModelRulesManager modelRulesManager;
    private final GraphUtils graphUtils;
    private final GraphIndexBuilder<? extends MutableIndex<Node, Edge>> indexBuilder;
    private final ShapeManager shapeManager;
    private final Event<CanvasElementAddedEvent> canvasElementAddedEvent;
    private final Event<CanvasElementRemovedEvent> canvasElementRemovedEvent;
    private final Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent;
    private final Event<CanvasElementsClearEvent> canvasElementsClearEvent;
    private final CanvasCommandFactory canvasCommandFactory;
    private final String uuid;
    private final List<CanvasElementListener> listeners = new LinkedList<CanvasElementListener>();
    private C canvas;
    private D diagram;
    private MutableIndex<?, ?> graphIndex;

    @Inject
    public AbstractCanvasHandler(ClientDefinitionManager clientDefinitionManager, ClientFactoryService clientFactoryServices, GraphRulesManager graphRulesManager, ModelRulesManager modelRulesManager, GraphUtils graphUtils, GraphIndexBuilder<? extends MutableIndex<Node, Edge>> indexBuilder, ShapeManager shapeManager, Event<CanvasElementAddedEvent> canvasElementAddedEvent, Event<CanvasElementRemovedEvent> canvasElementRemovedEvent, Event<CanvasElementUpdatedEvent> canvasElementUpdatedEvent, Event<CanvasElementsClearEvent> canvasElementsClearEvent, CanvasCommandFactory canvasCommandFactory) {
        this.clientDefinitionManager = clientDefinitionManager;
        this.clientFactoryServices = clientFactoryServices;
        this.modelRulesManager = modelRulesManager;
        this.graphRulesManager = graphRulesManager;
        this.graphUtils = graphUtils;
        this.indexBuilder = indexBuilder;
        this.shapeManager = shapeManager;
        this.canvasElementAddedEvent = canvasElementAddedEvent;
        this.canvasElementRemovedEvent = canvasElementRemovedEvent;
        this.canvasElementUpdatedEvent = canvasElementUpdatedEvent;
        this.canvasElementsClearEvent = canvasElementsClearEvent;
        this.canvasCommandFactory = canvasCommandFactory;
        this.uuid = UUID.uuid();
    }

    public CanvasHandler<D, C> initialize(C canvas) {
        this.canvas = canvas;
        return this;
    }

    public AbstractCanvasHandler<D, C> draw(D diagram) {
        this.diagram = diagram;
        this.graphIndex = (MutableIndex)this.indexBuilder.build(diagram.getGraph());
        this.initializeGraphBounds(diagram);
        this.doLoadRules();
        return this;
    }

    private void initializeGraphBounds(D diagram) {
        double w = this.getCanvas().getWidth();
        double h = this.getCanvas().getHeight();
        BoundsImpl bounds = new BoundsImpl(new BoundImpl(Double.valueOf(0.0), Double.valueOf(0.0)), new BoundImpl(Double.valueOf(w), Double.valueOf(h)));
        Graph graph = diagram.getGraph();
        ((DefinitionSet)graph.getContent()).setBounds((Bounds)bounds);
    }

    protected void doLoadRules() {
        String defSetId = this.getDiagram().getMetadata().getDefinitionSetId();
        this.clientFactoryServices.newDefinition(defSetId, new ServiceCallback<Object>(){

            public void onSuccess(Object definitionSet) {
                Collection rules = AbstractCanvasHandler.this.clientDefinitionManager.adapters().forRules().getRules(definitionSet);
                if (rules != null) {
                    for (Rule rule : rules) {
                        AbstractCanvasHandler.this.graphRulesManager.addRule(rule);
                        AbstractCanvasHandler.this.modelRulesManager.addRule(rule);
                    }
                }
                AbstractCanvasHandler.this.canvasCommandFactory.DRAW().execute(AbstractCanvasHandler.this);
            }

            public void onError(ClientRuntimeError error) {
                AbstractCanvasHandler.this.showError(error);
            }
        });
    }

    public C getCanvas() {
        return this.canvas;
    }

    public D getDiagram() {
        return this.diagram;
    }

    public void register(String shapeSetId, Element<View<?>> candidate) {
        ShapeFactory factory = this.shapeManager.getShapeSet(shapeSetId).getShapeFactory();
        this.register((ShapeFactory<Object, AbstractCanvasHandler, Shape>)factory, candidate, true);
    }

    public void register(ShapeFactory<Object, AbstractCanvasHandler, Shape> factory, Element<View<?>> candidate, boolean fireEvents) {
        assert (factory != null && candidate != null);
        Shape shape = factory.build(((View)candidate.getContent()).getDefinition(), (Object)this);
        if (null == shape.getUUID()) {
            shape.setUUID(candidate.getUUID());
        }
        shape.getShapeView().setZIndex(0);
        ((AbstractCanvas)this.canvas).addShape(shape);
        ((AbstractCanvas)this.canvas).draw();
        if (fireEvents) {
            this.fireCanvasElementAdded(candidate);
            this.afterElementAdded(candidate, shape);
        }
    }

    public void deregister(Element element) {
        this.deregister(element, true);
    }

    public void deregister(Element element, boolean fireEvents) {
        Shape shape = ((AbstractCanvas)this.canvas).getShape(element.getUUID());
        if (fireEvents) {
            this.fireCanvasElementRemoved(element);
            this.beforeElementDeleted(element, shape);
        }
        this.doDeregister(shape, element);
        ((AbstractCanvas)this.canvas).deleteShape(shape);
        ((AbstractCanvas)this.canvas).draw();
        if (fireEvents) {
            this.afterElementDeleted(element, shape);
        }
    }

    protected void doDeregister(Shape shape, Element element) {
    }

    public void applyElementMutation(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, true, true, mutationContext);
    }

    public void updateElementPosition(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, true, false, mutationContext);
    }

    public void updateElementProperties(Element element, MutationContext mutationContext) {
        this.applyElementMutation(element, false, true, mutationContext);
    }

    public void applyElementMutation(Element candidate, boolean applyPosition, boolean applyProperties, MutationContext mutationContext) {
        Shape shape;
        if (null != candidate && !this.isCanvasRoot(candidate) && (shape = ((AbstractCanvas)this.canvas).getShape(candidate.getUUID())) instanceof GraphShape) {
            GraphShape graphShape = (GraphShape)shape;
            if (applyPosition) {
                graphShape.applyPosition(candidate, mutationContext);
            }
            if (applyProperties) {
                graphShape.applyProperties((Object)candidate, mutationContext);
            }
            this.beforeElementUpdated(candidate, (Shape)graphShape);
            ((AbstractCanvas)this.canvas).draw();
            this.fireCanvasElementUpdated(candidate);
            this.afterElementUpdated(candidate, (Shape)graphShape);
        }
    }

    public void addChild(Element parent, Element child) {
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = ((AbstractCanvas)this.canvas).getShape(parent.getUUID());
            Shape childShape = ((AbstractCanvas)this.canvas).getShape(child.getUUID());
            this.handleParentChildZIndex(parent, child, parentShape, childShape, true);
            ((AbstractCanvas)this.canvas).addChildShape(parentShape, childShape);
        }
    }

    public void removeChild(String parentUUID, String childUUID) {
        if (!this.isCanvasRoot(parentUUID)) {
            Shape parentShape = ((AbstractCanvas)this.canvas).getShape(parentUUID);
            Shape childShape = ((AbstractCanvas)this.canvas).getShape(childUUID);
            this.handleParentChildZIndex(null, null, parentShape, childShape, false);
            ((AbstractCanvas)this.canvas).deleteChildShape(parentShape, childShape);
        }
    }

    private boolean isCanvasRoot(Element parent) {
        return CanvasLayoutUtils.isCanvasRoot(this.getDiagram(), parent);
    }

    private boolean isCanvasRoot(String pUUID) {
        return CanvasLayoutUtils.isCanvasRoot(this.getDiagram(), pUUID);
    }

    public void dock(Element parent, Element child) {
        if (!this.isCanvasRoot(parent)) {
            Shape parentShape = ((AbstractCanvas)this.canvas).getShape(parent.getUUID());
            Shape childShape = ((AbstractCanvas)this.canvas).getShape(child.getUUID());
            this.handleParentChildZIndex(parent, child, parentShape, childShape, true);
            ((AbstractCanvas)this.canvas).dock(parentShape, childShape);
        }
    }

    public void undock(String parentUUID, String childUUID) {
        if (!this.isCanvasRoot(parentUUID)) {
            Shape parentShape = ((AbstractCanvas)this.canvas).getShape(parentUUID);
            Shape childShape = ((AbstractCanvas)this.canvas).getShape(childUUID);
            this.handleParentChildZIndex(null, null, parentShape, childShape, false);
            ((AbstractCanvas)this.canvas).undock(parentShape, childShape);
        }
    }

    protected void handleParentChildZIndex(Element parent, Element child, Shape parentShape, Shape childShape, boolean add) {
        if (add) {
            this.handleZIndex(childShape, parentShape.getShapeView().getZIndex() + 1);
            this.handleZIndex(child, parentShape.getShapeView().getZIndex() + 1);
        } else {
            this.handleZIndex(childShape, 0);
            Element element = this.getGraphIndex().get(childShape.getUUID());
            if (null != element) {
                this.handleZIndex(element, 0);
            }
        }
    }

    protected void handleZIndex(Element child, int zindex) {
        Node childNode;
        List outEdges;
        if (child instanceof Node && null != (outEdges = (childNode = (Node)child).getOutEdges()) && !outEdges.isEmpty()) {
            LinkedHashSet<String> suuids = new LinkedHashSet<String>();
            for (Edge edge : outEdges) {
                if (!(edge.getContent() instanceof View)) continue;
                suuids.add(edge.getUUID());
            }
            this.handleZIndex(suuids, zindex);
        }
    }

    protected void handleZIndex(Set<String> shapeUUIDs, int zindex) {
        for (String suuid : shapeUUIDs) {
            Shape edgeShape = ((AbstractCanvas)this.canvas).getShape(suuid);
            this.handleZIndex(edgeShape, zindex);
        }
    }

    protected void handleZIndex(Shape shape, int zindex) {
        if (null != shape) {
            shape.getShapeView().setZIndex(zindex);
        }
    }

    public void clearCanvas() {
        this.fireCanvasClear();
        this.canvasElementsClearEvent.fire((Object)new CanvasElementsClearEvent((CanvasHandler)this));
        ((AbstractCanvas)this.canvas).clear();
        ((AbstractCanvas)this.canvas).draw();
    }

    public CanvasHandler<D, C> clear() {
        ((AbstractCanvas)this.canvas).clear();
        this.graphIndex.clear();
        this.graphIndex = null;
        this.diagram = null;
        return this;
    }

    public void destroy() {
        ((AbstractCanvas)this.canvas).destroy();
        this.graphIndex.clear();
        this.listeners.clear();
        this.canvas = null;
        this.graphIndex = null;
        this.diagram = null;
    }

    public HasCanvasListeners<CanvasElementListener> addRegistrationListener(CanvasElementListener instance) {
        this.listeners.add(instance);
        return this;
    }

    public HasCanvasListeners<CanvasElementListener> removeRegistrationListener(CanvasElementListener instance) {
        this.listeners.remove(instance);
        return this;
    }

    public HasCanvasListeners<CanvasElementListener> clearRegistrationListeners() {
        this.listeners.clear();
        return this;
    }

    public void fireCanvasElementRemoved(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.deregister((Object)candidate);
        }
    }

    public void fireCanvasElementAdded(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.register((Object)candidate);
        }
    }

    public void fireCanvasElementUpdated(Element candidate) {
        for (CanvasElementListener instance : this.listeners) {
            instance.update(candidate);
        }
    }

    protected void fireCanvasClear() {
        for (CanvasElementListener instance : this.listeners) {
            instance.clear();
        }
    }

    protected void afterElementAdded(Element element, Shape shape) {
        this.canvasElementAddedEvent.fire((Object)new CanvasElementAddedEvent((CanvasHandler)this, element));
    }

    protected void beforeElementDeleted(Element element, Shape shape) {
        this.canvasElementRemovedEvent.fire((Object)new CanvasElementRemovedEvent((CanvasHandler)this, element));
    }

    protected void afterElementDeleted(Element element, Shape shape) {
    }

    protected void beforeElementUpdated(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.beforeDraw();
        }
    }

    protected void afterElementUpdated(Element element, Shape shape) {
        if (shape instanceof Lifecycle) {
            Lifecycle lifecycle = (Lifecycle)shape;
            lifecycle.afterDraw();
        }
        this.canvasElementUpdatedEvent.fire((Object)new CanvasElementUpdatedEvent((CanvasHandler)this, element));
    }

    protected void showError(ClientRuntimeError error) {
        String message = error.getThrowable() != null ? error.getThrowable().getMessage() : error.getMessage();
        this.log(Level.SEVERE, message);
    }

    public ClientDefinitionManager getClientDefinitionManager() {
        return this.clientDefinitionManager;
    }

    public ClientFactoryService getClientFactoryServices() {
        return this.clientFactoryServices;
    }

    public GraphRulesManager getGraphRulesManager() {
        return this.graphRulesManager;
    }

    public ModelRulesManager getModelRulesManager() {
        return this.modelRulesManager;
    }

    public GraphUtils getGraphUtils() {
        return this.graphUtils;
    }

    public Index<?, ?> getGraphIndex() {
        return this.graphIndex;
    }

    public GraphIndexBuilder<?> getIndexBuilder() {
        return this.indexBuilder;
    }

    public ShapeManager getShapeManager() {
        return this.shapeManager;
    }

    protected String getDefinitionId(Object definition) {
        return this.clientDefinitionManager.adapters().forDefinition().getId(definition);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AbstractCanvasHandler)) {
            return false;
        }
        AbstractCanvasHandler that = (AbstractCanvasHandler)o;
        return this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.uuid == null ? 0 : ~(~this.uuid.hashCode());
    }

    public String toString() {
        return "AbstractCanvasHandler [" + this.uuid + "]";
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

