/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddDockedNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.AddNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.ClearCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteConnectorCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DeleteNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.DrawCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.MorphNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.RemoveChildCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetChildNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionSourceNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.SetConnectionTargetNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UnDockNodeCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPositionCommand;
import org.kie.workbench.common.stunner.core.client.canvas.command.UpdateElementPropertyCommand;
import org.kie.workbench.common.stunner.core.definition.morph.MorphDefinition;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.definition.Definition;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

@ApplicationScoped
public class CanvasCommandFactory {
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    protected CanvasCommandFactory() {
        this.treeWalkTraverseProcessor = null;
    }

    @Inject
    public CanvasCommandFactory(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public AddNodeCommand ADD_NODE(Node candidate, String shapeSetId) {
        return new AddNodeCommand(candidate, shapeSetId);
    }

    public AddChildNodeCommand ADD_CHILD_NODE(Node parent, Node candidate, String shapeSetId) {
        return new AddChildNodeCommand(parent, candidate, shapeSetId);
    }

    public AddDockedNodeCommand ADD_DOCKED_NODE(Node parent, Node candidate, String shapeSetId) {
        return new AddDockedNodeCommand(parent, candidate, shapeSetId);
    }

    public AddConnectorCommand ADD_CONNECTOR(Node sourceNode, Edge candidate, int magnetIndex, String shapeSetId) {
        return new AddConnectorCommand(sourceNode, candidate, magnetIndex, shapeSetId);
    }

    public SetChildNodeCommand SET_CHILD_NODE(Node parent, Node candidate) {
        return new SetChildNodeCommand(parent, candidate);
    }

    public DockNodeCommand DOCK_NODE(Node parent, Node candidate) {
        return new DockNodeCommand(parent, candidate);
    }

    public DeleteNodeCommand DELETE_NODE(Node candidate) {
        return new DeleteNodeCommand(candidate);
    }

    public RemoveChildCommand REMOVE_CHILD(Node parent, Node candidate) {
        return new RemoveChildCommand(parent, candidate);
    }

    public UnDockNodeCommand UNDOCK_NODE(Node parent, Node candidate) {
        return new UnDockNodeCommand(parent, candidate);
    }

    public DeleteConnectorCommand DELETE_CONNECTOR(Edge candidate) {
        return new DeleteConnectorCommand(candidate);
    }

    public DrawCanvasCommand DRAW() {
        return new DrawCanvasCommand(this.treeWalkTraverseProcessor);
    }

    public MorphNodeCommand MORPH_NODE(Node<? extends Definition<?>, Edge> candidate, MorphDefinition morphDefinition, String morphTarget, String shapeSetId) {
        return new MorphNodeCommand(candidate, morphDefinition, morphTarget, shapeSetId);
    }

    public SetConnectionSourceNodeCommand SET_SOURCE_NODE(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> edge, int magnetIndex) {
        return new SetConnectionSourceNodeCommand(node, edge, magnetIndex);
    }

    public SetConnectionTargetNodeCommand SET_TARGET_NODE(Node<? extends View<?>, Edge> node, Edge<? extends View<?>, Node> edge, int magnetIndex) {
        return new SetConnectionTargetNodeCommand(node, edge, magnetIndex);
    }

    public UpdateElementPositionCommand UPDATE_POSITION(Node<View<?>, Edge> element, Double x, Double y) {
        return new UpdateElementPositionCommand(element, x, y);
    }

    public UpdateElementPropertyCommand UPDATE_PROPERTY(Element element, String propertyId, Object value) {
        return new UpdateElementPropertyCommand(element, propertyId, value);
    }

    public ClearCommand CLEAR_CANVAS() {
        return new ClearCommand();
    }
}

