/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.command;

import java.util.List;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.command.AbstractCanvasCommand;
import org.kie.workbench.common.stunner.core.client.canvas.util.CanvasLayoutUtils;
import org.kie.workbench.common.stunner.core.client.command.CanvasViolation;
import org.kie.workbench.common.stunner.core.client.shape.MutationContext;
import org.kie.workbench.common.stunner.core.client.util.ShapeUtils;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.graph.Edge;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Graph;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Child;
import org.kie.workbench.common.stunner.core.graph.content.relationship.Dock;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.AbstractTreeTraverseCallback;
import org.kie.workbench.common.stunner.core.graph.processing.traverse.tree.TreeWalkTraverseProcessor;

public final class DrawCanvasCommand
extends AbstractCanvasCommand {
    private final TreeWalkTraverseProcessor treeWalkTraverseProcessor;

    public DrawCanvasCommand(TreeWalkTraverseProcessor treeWalkTraverseProcessor) {
        this.treeWalkTraverseProcessor = treeWalkTraverseProcessor;
    }

    public CommandResult<CanvasViolation> execute(AbstractCanvasHandler context) {
        this.draw(context);
        return this.buildResult();
    }

    public CommandResult<CanvasViolation> undo(AbstractCanvasHandler context) {
        throw new UnsupportedOperationException("Draw cannot be undone, yet.");
    }

    private void draw(final AbstractCanvasHandler context) {
        final Object diagram = context.getDiagram();
        final String shapeSetId = context.getDiagram().getMetadata().getShapeSetId();
        this.treeWalkTraverseProcessor.useEdgeVisitorPolicy(TreeWalkTraverseProcessor.EdgeVisitorPolicy.VISIT_EDGE_AFTER_TARGET_NODE).traverse((Object)diagram.getGraph(), (Object)new AbstractTreeTraverseCallback<Graph, Node, Edge>(){

            public void startGraphTraversal(Graph graph) {
            }

            public boolean startNodeTraversal(Node node) {
                if (node.getContent() instanceof View) {
                    if (!CanvasLayoutUtils.isCanvasRoot(diagram, (Element)node)) {
                        View viewContent = (View)node.getContent();
                        context.register(shapeSetId, (Element<View<?>>)node);
                        context.applyElementMutation((Element)node, MutationContext.STATIC);
                    }
                    return true;
                }
                return false;
            }

            public boolean startEdgeTraversal(Edge edge) {
                Object content = edge.getContent();
                if (content instanceof View) {
                    View viewContent = (View)edge.getContent();
                    context.register(shapeSetId, (Element<View<?>>)edge);
                    context.applyElementMutation((Element)edge, MutationContext.STATIC);
                    ShapeUtils.applyConnections(edge, context, MutationContext.STATIC);
                    return true;
                }
                if (content instanceof Child) {
                    Object childContent;
                    Node child = edge.getTargetNode();
                    Node parent = edge.getSourceNode();
                    if (!DrawCanvasCommand.this.isDocked(child) && (childContent = child.getContent()) instanceof View) {
                        context.addChild((Element)parent, (Element)child);
                        context.applyElementMutation((Element)child, MutationContext.STATIC);
                    }
                    return true;
                }
                if (content instanceof Dock) {
                    Node docked = edge.getTargetNode();
                    Node parent = edge.getSourceNode();
                    Object dockedContent = docked.getContent();
                    if (dockedContent instanceof View) {
                        context.dock((Element)parent, (Element)docked);
                        context.applyElementMutation((Element)docked, MutationContext.STATIC);
                    }
                    return true;
                }
                return false;
            }

            public void endGraphTraversal() {
                super.endGraphTraversal();
                context.getCanvas().draw();
            }
        });
    }

    private boolean isDocked(Node child) {
        List edges;
        if (null != child && null != (edges = child.getInEdges()) && !edges.isEmpty()) {
            for (Edge edge : edges) {
                if (!this.isDockEdged(edge)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isDockEdged(Edge edge) {
        return edge.getContent() instanceof Dock;
    }
}

