/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls;

import java.util.HashMap;
import java.util.Map;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.CanvasRegistationControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractCanvasHandlerRegistrationControl
extends AbstractCanvasHandlerControl
implements CanvasRegistationControl<AbstractCanvasHandler, Element> {
    private final Map<String, ViewHandler<?>> handlers = new HashMap();

    public void update(Element element) {
    }

    protected void registerHandler(String uuid, ViewHandler<?> handler) {
        this.handlers.put(uuid, handler);
    }

    @Override
    protected void doDisable() {
        for (Map.Entry<String, ViewHandler<?>> entry : this.handlers.entrySet()) {
            String uuid = entry.getKey();
            Shape shape = this.canvasHandler.getCanvas().getShape(uuid);
            ViewHandler<?> handler = entry.getValue();
            this.doDeregisterHandler(shape, handler);
        }
    }

    public void deregister(Element element) {
        this.handlers.remove(element.getUUID());
    }

    protected void doDeregisterHandler(Shape shape, ViewHandler<?> handler) {
        if (null != shape && null != handler) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            hasEventHandlers.removeHandler(handler);
        }
    }

    public void deregisterAll() {
        this.handlers.clear();
    }

    protected boolean checkEventContext(AbstractCanvasHandlerEvent canvasHandlerEvent) {
        CanvasHandler _canvasHandler = canvasHandlerEvent.getCanvasHandler();
        return this.canvasHandler != null && this.canvasHandler.equals(_canvasHandler);
    }
}

