/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.actions;

import com.google.gwt.user.client.ui.IsWidget;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.actions.CanvasNameEditionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.CanvasFocusedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyDownEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.keyboard.KeyboardEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.components.actions.NameEditBox;
import org.kie.workbench.common.stunner.core.client.components.views.FloatingView;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.HasTitle;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseDoubleClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextOutEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextOutHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextOverEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.TextOverHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;
import org.uberfire.commons.validation.PortablePreconditions;
import org.uberfire.mvp.Command;

@Dependent
public class CanvasNameEditionControlImpl
extends AbstractCanvasHandlerRegistrationControl
implements CanvasNameEditionControl<AbstractCanvasHandler, Element> {
    private static final int FLOATING_VIEW_TIMEOUT = 3000;
    private static final double SHAPE_EDIT_ALPH = 0.2;
    FloatingView<IsWidget> floatingView;
    NameEditBox<AbstractCanvasHandler, Element> nameEditBox;
    Event<CanvasElementSelectedEvent> elementSelectedEvent;
    private String uuid;
    private final Command floatingHideCallback = this::hide;

    @Inject
    public CanvasNameEditionControlImpl(FloatingView<IsWidget> floatingView, NameEditBox<AbstractCanvasHandler, Element> nameEditBox, Event<CanvasElementSelectedEvent> elementSelectedEvent) {
        this.floatingView = floatingView;
        this.nameEditBox = nameEditBox;
        this.elementSelectedEvent = elementSelectedEvent;
        this.uuid = null;
    }

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        this.nameEditBox.initialize((CanvasHandler)canvasHandler, () -> {
            this.hide();
            this.elementSelectedEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)canvasHandler, this.uuid));
        });
        this.floatingView.hide().setHideCallback(this.floatingHideCallback).setTimeOut(3000).add((Object)this.nameEditBox.asWidget());
    }

    public void register(final Element element) {
        ShapeView shapeView;
        Shape<?> shape = this.getShape(element.getUUID());
        if (null != shape && (shapeView = shape.getShapeView()) instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shapeView;
            MouseDoubleClickHandler doubleClickHandler = new MouseDoubleClickHandler(){

                public void handle(MouseDoubleClickEvent event) {
                    CanvasNameEditionControlImpl.this.show(element, event.getClientX(), event.getClientY());
                }
            };
            hasEventHandlers.addHandler(ViewEventType.MOUSE_DBL_CLICK, (ViewHandler)doubleClickHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)doubleClickHandler);
            TextOverHandler overHandler = new TextOverHandler(){

                public void handle(TextOverEvent event) {
                    CanvasNameEditionControlImpl.this.canvasHandler.getCanvas().getView().setCursor(AbstractCanvas.Cursors.TEXT);
                }
            };
            hasEventHandlers.addHandler(ViewEventType.TEXT_OVER, (ViewHandler)overHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)overHandler);
            TextOutHandler outHandler = new TextOutHandler(){

                public void handle(TextOutEvent event) {
                    CanvasNameEditionControlImpl.this.canvasHandler.getCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
                }
            };
            hasEventHandlers.addHandler(ViewEventType.TEXT_OUT, (ViewHandler)outHandler);
            this.registerHandler(shape.getUUID(), (ViewHandler<?>)outHandler);
        }
    }

    public CanvasNameEditionControl<AbstractCanvasHandler, Element> show(Element item, double x, double y) {
        Double[] size;
        this.uuid = item.getUUID();
        this.enableShapeEdit();
        this.nameEditBox.show(item);
        try {
            size = GraphUtils.getSize((View)((View)item.getContent()));
        }
        catch (ClassCastException e) {
            size = null;
        }
        double rx = null != size ? size[0] / 2.0 : 0.0;
        this.floatingView.setX(x - rx).setY(y).show();
        return this;
    }

    public CanvasNameEditionControl<AbstractCanvasHandler, Element> hide() {
        if (this.isVisible()) {
            this.disableShapeEdit();
            this.uuid = null;
            this.nameEditBox.hide();
            this.floatingView.hide();
        }
        return this;
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.disableShapeEdit();
        this.uuid = null;
        this.nameEditBox.hide();
        this.nameEditBox = null;
        this.floatingView.destroy();
        this.floatingView = null;
    }

    private boolean enableShapeEdit() {
        return this.setShapeEditMode(true);
    }

    private boolean disableShapeEdit() {
        return this.setShapeEditMode(false);
    }

    private boolean setShapeEditMode(boolean editMode) {
        Shape<?> shape = this.getShape(this.uuid);
        if (null != shape) {
            HasTitle hasTitle = (HasTitle)shape.getShapeView();
            double alpha = editMode ? 0.2 : 1.0;
            shape.getShapeView().setFillAlpha(alpha);
            hasTitle.setTitleAlpha(alpha);
            this.getCanvas().draw();
            return true;
        }
        return false;
    }

    private Shape<?> getShape(String uuid) {
        return null != uuid ? this.getCanvas().getShape(uuid) : null;
    }

    private boolean isVisible() {
        return null != this.uuid;
    }

    private Canvas getCanvas() {
        return this.canvasHandler.getCanvas();
    }

    void onKeyDownEvent(@Observes KeyDownEvent keyDownEvent) {
        PortablePreconditions.checkNotNull((String)"keyDownEvent", (Object)keyDownEvent);
        KeyboardEvent.Key key = keyDownEvent.getKey();
        if (null != key && KeyboardEvent.Key.ESC.equals((Object)key)) {
            this.hide();
        }
    }

    void onCanvasFocusedEvent(@Observes CanvasFocusedEvent canvasFocusedEvent) {
        PortablePreconditions.checkNotNull((String)"canvasFocusedEvent", (Object)canvasFocusedEvent);
        this.hide();
    }
}

