/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.drag;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasGrid;
import org.kie.workbench.common.stunner.core.client.canvas.Point2D;
import org.kie.workbench.common.stunner.core.client.canvas.command.CanvasCommandFactory;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.drag.DragControl;
import org.kie.workbench.common.stunner.core.client.command.CanvasCommandManager;
import org.kie.workbench.common.stunner.core.client.command.Session;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.ShapeView;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.command.Command;
import org.kie.workbench.common.stunner.core.command.CommandResult;
import org.kie.workbench.common.stunner.core.command.util.CommandUtils;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.kie.workbench.common.stunner.core.graph.Node;
import org.kie.workbench.common.stunner.core.graph.content.view.View;
import org.kie.workbench.common.stunner.core.graph.util.GraphUtils;

@Dependent
public class DragControlImpl
extends AbstractCanvasHandlerRegistrationControl
implements DragControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(DragControlImpl.class.getName());
    private final CanvasCommandFactory canvasCommandFactory;
    private final CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager;
    private CanvasGrid dragGrid;

    @Inject
    public DragControlImpl(CanvasCommandFactory canvasCommandFactory, @Session CanvasCommandManager<AbstractCanvasHandler> canvasCommandManager) {
        this.canvasCommandFactory = canvasCommandFactory;
        this.canvasCommandManager = canvasCommandManager;
    }

    public DragControl<AbstractCanvasHandler, Element> setDragGrid(CanvasGrid grid) {
        this.dragGrid = grid;
        return this;
    }

    public void register(final Element element) {
        Canvas canvas = this.canvasHandler.getCanvas();
        Shape shape = canvas.getShape(element.getUUID());
        if (shape.getShapeView() instanceof HasEventHandlers) {
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            DragHandler handler = new DragHandler((AbstractCanvas)canvas, shape){
                private final double[] shapeSize = new double[]{0.0, 0.0};
                private CanvasGrid grid = null;
                final /* synthetic */ AbstractCanvas val$canvas;
                final /* synthetic */ Shape val$shape;
                {
                    this.val$canvas = abstractCanvas;
                    this.val$shape = shape;
                }

                public void start(DragEvent event) {
                    Double[] size = GraphUtils.getSize((View)((View)element.getContent()));
                    this.shapeSize[0] = size[0];
                    this.shapeSize[1] = size[1];
                    if (DragControlImpl.this.isDragGridEnabled()) {
                        this.grid = this.val$canvas.getGrid();
                        if (null == this.grid) {
                            this.val$canvas.setGrid(DragControlImpl.this.dragGrid);
                        }
                    }
                }

                public void handle(DragEvent event) {
                    DragControlImpl.this.ensureDragConstrains(this.val$shape.getShapeView(), this.shapeSize);
                }

                public void end(DragEvent event) {
                    double x = this.val$shape.getShapeView().getShapeX();
                    double y = this.val$shape.getShapeView().getShapeY();
                    CommandResult result = DragControlImpl.this.canvasCommandManager.execute((Object)DragControlImpl.this.canvasHandler, (Command)DragControlImpl.this.canvasCommandFactory.UPDATE_POSITION((Node)element, x, y));
                    if (CommandUtils.isError((CommandResult)result)) {
                        // empty if block
                    }
                    if (DragControlImpl.this.isDragGridEnabled()) {
                        this.val$canvas.setGrid(this.grid);
                        this.grid = null;
                    }
                }
            };
            hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)handler);
            this.registerHandler(element.getUUID(), (ViewHandler<?>)handler);
        }
    }

    private void ensureDragConstrains(ShapeView<?> shapeView, double[] shapeSize) {
        boolean yb;
        int mw = this.canvasHandler.getCanvas().getWidth();
        int mh = this.canvasHandler.getCanvas().getHeight();
        Point2D sa = shapeView.getShapeAbsoluteLocation();
        LOGGER.log(Level.FINE, "Ensuring drag constraints for absolute coordinates at [" + sa.getX() + ", " + sa.getY() + "]");
        double ax = (double)mw - shapeSize[0];
        double ay = (double)mh - shapeSize[1];
        boolean xb = sa.getX() >= ax || sa.getX() < 0.0;
        boolean bl = yb = sa.getY() >= ay || sa.getY() < 0.0;
        if (xb || yb) {
            double tx;
            double d = sa.getX() >= ax ? ax : (tx = sa.getX() < 0.0 ? 0.0 : sa.getX());
            double ty = sa.getY() >= ay ? ay : (sa.getY() < 0.0 ? 0.0 : sa.getY());
            LOGGER.log(Level.FINE, "Setting constraint coordinates at [" + tx + ", " + ty + "]");
            shapeView.setShapeX(tx);
            shapeView.setShapeY(ty);
        }
    }

    private boolean isDragGridEnabled() {
        return null != this.dragGrid;
    }
}

