/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.palette;

import com.google.gwt.core.client.GWT;
import org.kie.workbench.common.stunner.core.client.ShapeManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuildRequest;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.BuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.ElementBuilderControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.builder.request.ElementBuildRequestImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.palette.CanvasPaletteControl;
import org.kie.workbench.common.stunner.core.client.components.palette.Palette;
import org.kie.workbench.common.stunner.core.client.components.palette.factory.PaletteFactory;
import org.kie.workbench.common.stunner.core.client.components.palette.model.definition.DefinitionSetPalette;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteGrid;
import org.kie.workbench.common.stunner.core.client.components.palette.view.PaletteView;
import org.kie.workbench.common.stunner.core.client.service.ClientFactoryService;
import org.kie.workbench.common.stunner.core.client.service.ClientRuntimeError;
import org.kie.workbench.common.stunner.core.client.service.ServiceCallback;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseDoubleClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseDoubleClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.diagram.Metadata;

public abstract class AbstractCanvasPaletteControl
extends AbstractCanvasHandlerControl
implements CanvasPaletteControl<AbstractCanvasHandler> {
    protected PaletteFactory<DefinitionSetPalette, ? extends Palette<DefinitionSetPalette>> paletteFactory;
    protected ElementBuilderControl<AbstractCanvasHandler> elementBuilderControl;
    protected ClientFactoryService factoryServices;
    protected ShapeManager shapeManager;
    protected ViewHandler<?> layerClickHandler;
    protected Palette<DefinitionSetPalette> palette;
    protected boolean paletteVisible;

    public AbstractCanvasPaletteControl(PaletteFactory<DefinitionSetPalette, ? extends Palette<DefinitionSetPalette>> paletteFactory, ElementBuilderControl<AbstractCanvasHandler> elementBuilderControl, ClientFactoryService factoryServices, ShapeManager shapeManager) {
        this.paletteFactory = paletteFactory;
        this.elementBuilderControl = elementBuilderControl;
        this.factoryServices = factoryServices;
        this.shapeManager = shapeManager;
        this.palette = null;
        this.paletteVisible = false;
    }

    protected abstract void attachPaletteView();

    protected abstract PaletteView getPaletteView();

    protected abstract PaletteGrid getGrid();

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        this.elementBuilderControl.enable((Object)canvasHandler);
        Layer layer = canvasHandler.getCanvas().getLayer();
        MouseDoubleClickHandler doubleClickHandler = new MouseDoubleClickHandler(){

            public void handle(MouseDoubleClickEvent event) {
                if (AbstractCanvasPaletteControl.this.isPaletteVisible()) {
                    AbstractCanvasPaletteControl.this.hide();
                } else {
                    AbstractCanvasPaletteControl.this.show(event.getX(), event.getY());
                }
            }
        };
        layer.addHandler(ViewEventType.MOUSE_DBL_CLICK, (ViewHandler)doubleClickHandler);
        this.layerClickHandler = doubleClickHandler;
    }

    @Override
    protected void doDisable() {
        if (null != this.elementBuilderControl) {
            this.elementBuilderControl.disable();
            this.elementBuilderControl = null;
        }
        this.hide();
        this.palette = null;
        if (null != this.layerClickHandler) {
            this.canvasHandler.getCanvas().getLayer().removeHandler(this.layerClickHandler);
            this.layerClickHandler = null;
        }
    }

    private void initializePalette() {
        if (null == this.palette) {
            String ssid = this.getShapeSetId(this.canvasHandler.getDiagram().getMetadata());
            this.palette = this.paletteFactory.newPalette(ssid, this.getGrid());
            this.palette.onItemClick(this::_onItemClick);
            this.palette.onClose(() -> {
                this.hide();
                return true;
            });
            this.attachPaletteView();
        }
    }

    private String getShapeSetId(Metadata metadata) {
        String ssid = metadata.getShapeSetId();
        if (null == ssid) {
            return this.shapeManager.getDefaultShapeSet(metadata.getDefinitionSetId()).getId();
        }
        return ssid;
    }

    public CanvasPaletteControl<AbstractCanvasHandler> show(double x, double y) {
        this.paletteVisible = true;
        this.initializePalette();
        this.getPaletteView().setX(x);
        this.getPaletteView().setY(y);
        this.getPaletteView().show();
        return this;
    }

    public CanvasPaletteControl<AbstractCanvasHandler> hide() {
        this.paletteVisible = false;
        if (null != this.getPaletteView()) {
            this.getPaletteView().hide();
        }
        return this;
    }

    private boolean _onItemClick(String id, double mouseX, double mouseY, final double itemX, final double itemY) {
        this.factoryServices.newDefinition(id, new ServiceCallback<Object>(){

            public void onSuccess(Object def) {
                ElementBuildRequestImpl request = new ElementBuildRequestImpl(itemX, itemY, def);
                AbstractCanvasPaletteControl.this.elementBuilderControl.build((BuildRequest)request, new BuilderControl.BuildCallback(){

                    public void onSuccess(String uuid) {
                        AbstractCanvasPaletteControl.this.onItemBuilt(uuid);
                    }

                    public void onError(ClientRuntimeError error) {
                        AbstractCanvasPaletteControl.this.onError(error);
                    }
                });
            }

            public void onError(ClientRuntimeError error) {
                AbstractCanvasPaletteControl.this.onError(error);
            }
        });
        return true;
    }

    protected void onItemBuilt(String uuid) {
        this.hide();
    }

    private void onError(ClientRuntimeError error) {
        GWT.log((String)("ERROR: " + error.toString()));
    }

    private boolean isPaletteVisible() {
        return this.paletteVisible;
    }
}

