/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.select;

import com.google.gwt.logging.client.LogConfiguration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.event.Event;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Canvas;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.Layer;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.select.SelectionControl;
import org.kie.workbench.common.stunner.core.client.canvas.event.registration.CanvasShapeRemovedEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.ShapeState;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.MouseClickHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.commons.validation.PortablePreconditions;

public abstract class AbstractSelectionControl
extends AbstractCanvasHandlerRegistrationControl
implements SelectionControl<AbstractCanvasHandler, Element> {
    private static Logger LOGGER = Logger.getLogger(AbstractSelectionControl.class.getName());
    Event<CanvasElementSelectedEvent> elementSelectedEventEvent;
    Event<CanvasClearSelectionEvent> clearSelectionEventEvent;
    private final List<String> selectedElements = new ArrayList<String>();
    private ViewHandler<?> layerClickHandler;

    @Inject
    public AbstractSelectionControl(Event<CanvasElementSelectedEvent> elementSelectedEventEvent, Event<CanvasClearSelectionEvent> clearSelectionEventEvent) {
        this.elementSelectedEventEvent = elementSelectedEventEvent;
        this.clearSelectionEventEvent = clearSelectionEventEvent;
    }

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        Layer layer = canvasHandler.getCanvas().getLayer();
        MouseClickHandler clickHandler = new MouseClickHandler(){

            public void handle(MouseClickEvent event) {
                if (event.isButtonLeft()) {
                    AbstractSelectionControl.this.handleLayerClick(!event.isShiftKeyDown());
                }
            }
        };
        layer.addHandler(ViewEventType.MOUSE_CLICK, (ViewHandler)clickHandler);
        this.layerClickHandler = clickHandler;
    }

    protected abstract void register(Element var1, Shape<?> var2);

    public void register(Element element) {
        Shape shape = this.getCanvas().getShape(element.getUUID());
        if (null != shape) {
            this.register(element, shape);
        }
    }

    protected void handleElementSelection(Element element, boolean selected, boolean clearSelection) {
        if (clearSelection) {
            this.clearSelection();
        }
        if (selected) {
            this.log(Level.FINE, "Deselect [element=" + element.getUUID() + "]");
            this.deselect(element);
        } else {
            this.log(Level.FINE, "Select [element=" + element.getUUID() + "]");
            this.select(element);
        }
    }

    protected void handleLayerClick(boolean clearSelection) {
        String canvasRootUUID;
        if (clearSelection) {
            this.clearSelection();
        }
        if (null != (canvasRootUUID = this.canvasHandler.getDiagram().getMetadata().getCanvasRootUUID())) {
            this.elementSelectedEventEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)this.canvasHandler, canvasRootUUID));
        } else {
            this.clearSelectionEventEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)this.canvasHandler));
        }
    }

    @Override
    public void deregister(Element element) {
        super.deregister(element);
        this.selectedElements.remove(element.getUUID());
    }

    @Override
    public void deregisterAll() {
        super.deregisterAll();
        this.selectedElements.clear();
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        if (null != this.layerClickHandler) {
            this.getCanvas().getLayer().removeHandler(this.layerClickHandler);
            this.layerClickHandler = null;
        }
        this.selectedElements.clear();
    }

    protected void updateViewShapesState() {
        if (null != this.getCanvas()) {
            List shapes = this.getCanvas().getShapes();
            for (Shape shape : shapes) {
                boolean isSelected;
                boolean bl = isSelected = !this.selectedElements.isEmpty() && this.selectedElements.contains(shape.getUUID());
                if (isSelected) {
                    this.selectShape(shape);
                    continue;
                }
                this.deselectShape(shape);
            }
            this.getCanvas().draw();
        }
    }

    protected void selectShape(Shape shape) {
        shape.applyState(ShapeState.SELECTED);
        this.getCanvas().draw();
    }

    protected void deselectShape(Shape shape) {
        shape.applyState(ShapeState.NONE);
        this.getCanvas().draw();
    }

    public SelectionControl<AbstractCanvasHandler, Element> select(String uuid, boolean fireEvent) {
        this.selectedElements.add(uuid);
        this.updateViewShapesState();
        if (fireEvent) {
            this.elementSelectedEventEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)this.canvasHandler, uuid));
        }
        return this;
    }

    public SelectionControl<AbstractCanvasHandler, Element> select(Element element) {
        return this.select(element, true);
    }

    public SelectionControl<AbstractCanvasHandler, Element> select(Element element, boolean fireEvent) {
        this.select(element.getUUID(), fireEvent);
        return this;
    }

    public SelectionControl<AbstractCanvasHandler, Element> deselect(String uuid, boolean fireEvent) {
        this.selectedElements.remove(uuid);
        this.updateViewShapesState();
        if (fireEvent) {
            this.fireCanvasClear();
        }
        return this;
    }

    public SelectionControl<AbstractCanvasHandler, Element> deselect(Element element) {
        return this.deselect(element, true);
    }

    public SelectionControl<AbstractCanvasHandler, Element> deselect(Element element, boolean fireEvent) {
        return this.deselect(element.getUUID(), fireEvent);
    }

    protected boolean isSelected(String uuid) {
        return uuid != null && this.selectedElements.contains(uuid);
    }

    public boolean isSelected(Element element) {
        return null != element && this.isSelected(element.getUUID());
    }

    public Collection<String> getSelectedItems() {
        return Collections.unmodifiableCollection(this.selectedElements);
    }

    public SelectionControl<AbstractCanvasHandler, Element> clearSelection() {
        return this.clearSelection(true);
    }

    public SelectionControl<AbstractCanvasHandler, Element> clearSelection(boolean fireEvent) {
        for (String uuid : this.selectedElements) {
            Shape shape = this.canvasHandler.getCanvas().getShape(uuid);
            if (null == shape) continue;
            this.deselectShape(shape);
        }
        this.selectedElements.clear();
        if (null != this.getCanvas()) {
            this.getCanvas().draw();
        }
        if (fireEvent) {
            this.fireCanvasClear();
        }
        return this;
    }

    void onShapeRemovedEvent(@Observes CanvasShapeRemovedEvent shapeRemovedEvent) {
        Shape shape;
        PortablePreconditions.checkNotNull((String)"shapeRemovedEvent", (Object)shapeRemovedEvent);
        if (null != this.getCanvas() && this.getCanvas().equals(shapeRemovedEvent.getCanvas()) && this.selectedElements.contains((shape = shapeRemovedEvent.getShape()).getUUID())) {
            this.deselect(shape.getUUID(), false);
        }
    }

    void onCanvasElementSelectedEvent(@Observes CanvasElementSelectedEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        String uuid = event.getElementUUID();
        if (null != this.canvasHandler && this.canvasHandler.equals(event.getCanvasHandler())) {
            this.doSelect(uuid);
        }
    }

    private void doSelect(String uuid) {
        if (!this.isSelected(uuid)) {
            this.clearSelection(false);
            this.select(uuid, false);
        }
    }

    void CanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.canvasHandler && this.canvasHandler.equals(event.getCanvasHandler())) {
            this.clearSelection(false);
        }
    }

    protected void fireCanvasClear() {
        this.clearSelectionEventEvent.fire((Object)new CanvasClearSelectionEvent((CanvasHandler)this.canvasHandler));
    }

    protected Canvas getCanvas() {
        return null != this.canvasHandler ? this.canvasHandler.getCanvas() : null;
    }

    private void log(Level level, String message) {
        if (LogConfiguration.loggingIsEnabled()) {
            LOGGER.log(level, message);
        }
    }
}

