/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox;

import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.Widget;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.enterprise.context.Dependent;
import javax.enterprise.event.Observes;
import javax.inject.Inject;
import org.jboss.errai.ioc.client.container.SyncBeanDef;
import org.jboss.errai.ioc.client.container.SyncBeanManager;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.AbstractCanvasHandlerRegistrationControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.ToolboxControlProvider;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ContextImpl;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.AbstractCanvasHandlerEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasClearSelectionEvent;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.client.components.toolbox.Toolbox;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButton;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxButtonGrid;
import org.kie.workbench.common.stunner.core.client.components.toolbox.ToolboxFactory;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.builder.ToolboxButtonBuilder;
import org.kie.workbench.common.stunner.core.client.components.toolbox.event.ToolboxButtonEvent;
import org.kie.workbench.common.stunner.core.client.shape.NodeShape;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.client.shape.view.HasEventHandlers;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragEvent;
import org.kie.workbench.common.stunner.core.client.shape.view.event.DragHandler;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewEventType;
import org.kie.workbench.common.stunner.core.client.shape.view.event.ViewHandler;
import org.kie.workbench.common.stunner.core.graph.Element;
import org.uberfire.commons.validation.PortablePreconditions;

@Dependent
public class CanvasToolboxControl
extends AbstractCanvasHandlerRegistrationControl
implements ToolboxControl<AbstractCanvasHandler, Element>,
IsWidget {
    SyncBeanManager beanManager;
    ToolboxFactory toolboxFactory;
    View view;
    private final Map<String, List<Toolbox>> toolboxMap = new HashMap<String, List<Toolbox>>();
    private String currentToolboxUUID;

    @Inject
    public CanvasToolboxControl(SyncBeanManager beanManager, ToolboxFactory toolboxFactory, View view) {
        this.beanManager = beanManager;
        this.toolboxFactory = toolboxFactory;
        this.view = view;
        this.currentToolboxUUID = null;
    }

    protected List<ToolboxControlProvider<AbstractCanvasHandler, Element>> getToolboxProviders(Element element) {
        if (element.getContent() instanceof org.kie.workbench.common.stunner.core.graph.content.view.View) {
            org.kie.workbench.common.stunner.core.graph.content.view.View viewContent = (org.kie.workbench.common.stunner.core.graph.content.view.View)element.getContent();
            LinkedList<ToolboxControlProvider<AbstractCanvasHandler, Element>> result = new LinkedList<ToolboxControlProvider<AbstractCanvasHandler, Element>>();
            Collection beanDefSets = this.beanManager.lookupBeans(ToolboxControlProvider.class);
            for (SyncBeanDef providersSet : beanDefSets) {
                Object definition = viewContent.getDefinition();
                ToolboxControlProvider toolboxProvider = (ToolboxControlProvider)providersSet.newInstance();
                if (!toolboxProvider.supports(definition)) continue;
                result.add((ToolboxControlProvider<AbstractCanvasHandler, Element>)toolboxProvider);
            }
            return result;
        }
        return null;
    }

    @Override
    public void enable(AbstractCanvasHandler canvasHandler) {
        super.enable(canvasHandler);
        canvasHandler.getCanvas().addControl((IsWidget)this.asWidget());
    }

    @Override
    public void update(Element element) {
        super.update(element);
        this.deregister(element);
        this.register(element);
        this.canvasHandler.getCanvas().draw();
    }

    public void register(Element element) {
        this.doRegister(element);
    }

    private void doRegister(final Element element) {
        Shape shape = this.canvasHandler.getCanvas().getShape(element.getUUID());
        if (shape instanceof NodeShape) {
            List<ToolboxControlProvider<AbstractCanvasHandler, Element>> toolboxControlProviders = this.getToolboxProviders(element);
            if (null != toolboxControlProviders && !toolboxControlProviders.isEmpty()) {
                for (ToolboxControlProvider<AbstractCanvasHandler, Element> toolboxControlProvider : toolboxControlProviders) {
                    List commands = toolboxControlProvider.getCommands((CanvasHandler)this.canvasHandler, (Object)element);
                    if (null == commands || commands.isEmpty()) continue;
                    ToolboxBuilder toolboxBuilder = this.toolboxFactory.toolboxBuilder();
                    ToolboxButtonGrid grid = toolboxControlProvider.getGrid((CanvasHandler)this.canvasHandler, (Object)element);
                    toolboxBuilder.forLayer(this.canvasHandler.getCanvas().getLayer());
                    toolboxBuilder.forView(shape.getShapeView());
                    toolboxBuilder.direction(toolboxControlProvider.getOn(), toolboxControlProvider.getTowards());
                    toolboxBuilder.grid(grid);
                    ToolboxButtonBuilder buttonBuilder = this.toolboxFactory.toolboxButtonBuilder();
                    for (ToolboxCommand command : commands) {
                        ToolboxButton button = buttonBuilder.setIcon(command.getIcon((CanvasHandler)this.canvasHandler, (double)grid.getButtonSize(), (double)grid.getButtonSize())).setClickHandler(event -> this.fireCommandExecutionAndHideToolbox(element, command, event, Context.EventType.CLICK)).setMouseEnterHandler(event -> this.fireCommandExecution(element, command, event, Context.EventType.MOUSE_ENTER)).setMouseExitHandler(event -> this.fireCommandExecution(element, command, event, Context.EventType.MOUSE_EXIT)).setMouseDownHandler(event -> this.fireCommandExecutionAndHideToolbox(element, command, event, Context.EventType.MOUSE_DOWN)).build();
                        toolboxBuilder.add(button);
                    }
                    Toolbox toolbox = toolboxBuilder.build();
                    this.addToolbox(element.getUUID(), toolbox);
                }
            }
            HasEventHandlers hasEventHandlers = (HasEventHandlers)shape.getShapeView();
            DragHandler handler = new DragHandler(){

                public void handle(DragEvent event) {
                }

                public void start(DragEvent event) {
                    CanvasToolboxControl.this.hideToolboxes(element);
                }

                public void end(DragEvent event) {
                }
            };
            hasEventHandlers.addHandler(ViewEventType.DRAG, (ViewHandler)handler);
            this.registerHandler(element.getUUID(), (ViewHandler<?>)handler);
        }
    }

    private void addToolbox(String uuid, Toolbox toolbox) {
        if (null != uuid && null != toolbox) {
            List<Toolbox> toolboxes = this.toolboxMap.get(uuid);
            if (null == toolboxes) {
                toolboxes = new LinkedList<Toolbox>();
                this.toolboxMap.put(uuid, toolboxes);
            }
            toolboxes.add(toolbox);
        }
    }

    private void fireCommandExecution(Element element, ToolboxCommand command, ToolboxButtonEvent event, Context.EventType eventTypeType) {
        ContextImpl _context = new ContextImpl(this.canvasHandler, eventTypeType, event.getX(), event.getY(), event.getAbsoluteX(), event.getAbsoluteY(), event.getClientX(), event.getClientY());
        this.setCommandView(command).execute((Context)_context, element);
    }

    private void fireCommandExecutionAndHideToolbox(Element element, ToolboxCommand command, ToolboxButtonEvent event, Context.EventType eventTypeType) {
        this.fireCommandExecution(element, command, event, eventTypeType);
        this.hideToolboxes(element);
    }

    @Override
    public void deregister(Element element) {
        super.deregister(element);
        this.deregister(element.getUUID());
    }

    private void deregister(String uuid) {
        List<Toolbox> toolboxes = this.getToolboxes(uuid);
        if (null != toolboxes && !toolboxes.isEmpty()) {
            for (Toolbox toolbox : toolboxes) {
                toolbox.remove();
            }
            this.toolboxMap.remove(uuid);
        }
    }

    @Override
    public void deregisterAll() {
        super.deregisterAll();
        Collection<List<Toolbox>> allToolboxes = this.toolboxMap.values();
        for (List<Toolbox> toolboxes : allToolboxes) {
            for (Toolbox toolbox : toolboxes) {
                toolbox.remove();
            }
        }
        this.toolboxMap.clear();
    }

    @Override
    protected void doDisable() {
        super.doDisable();
        this.canvasHandler.getCanvas().deleteControl((IsWidget)this.asWidget());
        for (List<Toolbox> toolboxes : this.toolboxMap.values()) {
            if (null == toolboxes || toolboxes.isEmpty()) continue;
            for (Toolbox toolbox : toolboxes) {
                toolbox.remove();
            }
        }
    }

    private ToolboxCommand setCommandView(ToolboxCommand command) {
        this.view.clear();
        if (command instanceof IsWidget) {
            this.view.addWidget((IsWidget)((IsWidget)command).asWidget());
        }
        return command;
    }

    public Widget asWidget() {
        return this.view.asWidget();
    }

    void onCanvasElementSelectedEvent(@Observes CanvasElementSelectedEvent event) {
        String uuid;
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (this.checkEventContext((AbstractCanvasHandlerEvent)event) && null != (uuid = event.getElementUUID())) {
            this.switchVisibility(uuid);
        }
    }

    void CanvasClearSelectionEvent(@Observes CanvasClearSelectionEvent event) {
        PortablePreconditions.checkNotNull((String)"event", (Object)event);
        if (null != this.currentToolboxUUID) {
            this.setVisible(this.currentToolboxUUID, false);
            this.currentToolboxUUID = null;
        }
    }

    private boolean isVisible(String uuid) {
        return this.currentToolboxUUID != null && this.currentToolboxUUID.equals(uuid);
    }

    private void switchVisibility(String uuid) {
        if (this.isVisible(uuid)) {
            this.setVisible(this.currentToolboxUUID, false);
            this.currentToolboxUUID = null;
        } else {
            if (null != this.currentToolboxUUID) {
                this.setVisible(this.currentToolboxUUID, false);
            }
            this.setVisible(uuid, true);
            this.currentToolboxUUID = uuid;
        }
    }

    private void setVisible(String uuid, boolean visible) {
        List<Toolbox> toolboxes = this.getToolboxes(uuid);
        if (null != toolboxes) {
            for (Toolbox toolbox : toolboxes) {
                if (visible) {
                    toolbox.show();
                    continue;
                }
                toolbox.hide();
            }
        }
    }

    private void hideToolboxes(Element<?> element) {
        List<Toolbox> toolboxes = this.getToolboxes(element);
        if (null != toolboxes) {
            toolboxes.stream().forEach(Toolbox::hide);
        }
    }

    private List<Toolbox> getToolboxes(Element<?> element) {
        String uuid = null != element ? element.getUUID() : null;
        return null != uuid ? this.getToolboxes(uuid) : null;
    }

    private List<Toolbox> getToolboxes(String uuid) {
        return this.toolboxMap.get(uuid);
    }

    public static interface View
    extends IsWidget {
        public View addWidget(IsWidget var1);

        public View clear();
    }
}

