/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command;

import com.google.gwt.user.client.Timer;
import javax.enterprise.event.Event;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvas;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.CanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.ToolboxCommand;
import org.kie.workbench.common.stunner.core.client.canvas.event.selection.CanvasElementSelectedEvent;
import org.kie.workbench.common.stunner.core.graph.Element;

public abstract class AbstractToolboxCommand<I>
implements ToolboxCommand<AbstractCanvasHandler, I> {
    public void click(Context<AbstractCanvasHandler> context, Element element) {
    }

    public void mouseDown(Context<AbstractCanvasHandler> context, Element element) {
    }

    public void mouseEnter(Context<AbstractCanvasHandler> context, Element element) {
        ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getView().setCursor(AbstractCanvas.Cursors.POINTER);
    }

    public void mouseExit(Context<AbstractCanvasHandler> context, Element element) {
        ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getView().setCursor(AbstractCanvas.Cursors.AUTO);
    }

    public void execute(Context<AbstractCanvasHandler> context, Element element) {
        Context.EventType eventType = context.getEventType();
        switch (eventType) {
            case CLICK: {
                this.click(context, element);
                break;
            }
            case MOUSE_DOWN: {
                this.mouseDown(context, element);
                break;
            }
            case MOUSE_ENTER: {
                this.mouseEnter(context, element);
                break;
            }
            case MOUSE_EXIT: {
                this.mouseExit(context, element);
            }
        }
    }

    protected void fireElementSelectedEvent(Event<CanvasElementSelectedEvent> elementSelectedEvent, final AbstractCanvasHandler canvasHandler, String uuid) {
        canvasHandler.getCanvas().getLayer().disableHandlers();
        elementSelectedEvent.fire((Object)new CanvasElementSelectedEvent((CanvasHandler)canvasHandler, uuid));
        Timer t = new Timer(){

            public void run() {
                canvasHandler.getCanvas().getLayer().enableHandlers();
            }
        };
        t.schedule(500);
    }

    protected void fireLoadingStarted(Context<AbstractCanvasHandler> context) {
        ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().loadingStarted();
    }

    protected void fireLoadingCompleted(Context<AbstractCanvasHandler> context) {
        ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().loadingCompleted();
    }
}

