/*
 * Decompiled with CFR 0.152.
 */
package org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.actions;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import org.kie.workbench.common.stunner.core.client.canvas.AbstractCanvasHandler;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.Context;
import org.kie.workbench.common.stunner.core.client.canvas.controls.toolbox.command.actions.AbstractActionToolboxCommand;
import org.kie.workbench.common.stunner.core.client.components.glyph.DefinitionGlyphTooltip;
import org.kie.workbench.common.stunner.core.client.shape.Shape;
import org.kie.workbench.common.stunner.core.graph.Element;

@Dependent
public class MoveShapeDownToolboxCommand<I>
extends AbstractActionToolboxCommand<I> {
    private static Logger LOGGER = Logger.getLogger(MoveShapeDownToolboxCommand.class.getName());

    protected MoveShapeDownToolboxCommand() {
        this(null);
    }

    @Inject
    public MoveShapeDownToolboxCommand(DefinitionGlyphTooltip<?> glyphTooltip) {
        super(glyphTooltip);
    }

    public String getTitle() {
        return "Move Down";
    }

    @Override
    public void click(Context<AbstractCanvasHandler> context, Element element) {
        super.click(context, element);
        String uuid = element.getUUID();
        Shape shape = ((AbstractCanvasHandler)context.getCanvasHandler()).getCanvas().getShape(uuid);
        if (null != shape) {
            shape.getShapeView().setZIndex(shape.getShapeView().getZIndex() - 1);
            shape.getShapeView().moveDown();
        } else {
            LOGGER.log(Level.WARNING, "Shape not found for UUID [" + uuid + "]");
        }
    }

    public void destroy() {
    }
}

